/*
   *****************************************
   * GALAXIAN                              *
   * PROGRAMMING AND GRAPHICS              *
   * BY                                    *
   * PETER VAN DALEN                       *
   *                                       *
   * THIS GAME IS PROGRAMMED               *
   * FOR THE REMAKE COMPETITION            *
   * ISSUED BY FASTTRAK                    *
   *                                       *
   * PROGRAM INITIATED ON: 22nd MARCH 2002 *
   * PROGRAM FINISHED ON : 26th MARCH 2002 *
   *****************************************
*/

PROGRAM GALAXIAN;

CONST
    graph_size  =100;   // constant for graph_size (ROLMAO   :D)
    blue_alien  =1;     // constant for first alien type
    purple_alien=2;     // constant for second alien type
    red_alien   =3;     // constant for third alien type
    flagship    =4;     // constant for fourth alien type
    convoy      =1;     // constant for first alien gamestate
    charger     =2;     // constant for second alien gamestate
    total_aliens=45;    // constant for total number of aliens
    descend     =100;   // constant for alien y-coord. set up
    max_ships   =3;     // constant for initializing maximum number of ships
    rim         =150;   // constant for calculating edge of alien attack run
    _wave1      =1;     // number of attackwave
    _wave2      =3;     // number of attackwave
    _wave3      =2;     // number of attackwave
    _wave4      =4;     // number of attackwave
    n_frames    =50;    // number of frames
GLOBAL

//  ---------------------------------------------------------------------------
//  animation arrays
//  ---------------------------------------------------------------------------
    blue_alien_anim[]  =6 dup(127),6 dup(128),6 dup(129),6 dup(128);
    purple_alien_anim[]=6 dup(124),6 dup(125),6 dup(126),6 dup(125);
    red_alien_anim[]   =6 dup(121),6 dup(122),6 dup(123),6 dup(122);
//  ---------------------------------------------------------------------------
//  identifiers
//  ---------------------------------------------------------------------------
    file1;              // file identifier
    font1;              // font identifier
    font2;              // another font identifier
    fire1=false;        // variable for checking if spacebar has been pressed
    n_aliens;           // variable for checking for total number of aliens
    n_attacks;          // variable for checking number of attacks possible
    max_attacks;        // variable to make sure no. of attacks never exceed this one
    score;              // variable for calculating score
    highscore;          // variable for calculating highscore
    points;             // variable for calculating points - to be added to score
    bullet=false;       // checks if there is a bullet onscreen or not
    can_save=false;     // checks if score is higher than current highscore
    credits=0;          // checks which graph has to be displayed for credits
    next_alien;         // variable used for alien_setup process and structure
    _flag1;             // variable for calling 1st flagship
    _flag2;             // variable for calling 2nd flagship
    groupattack1;       // variable for initiating 1st groupattack
    groupattack2;       // variable for initiating 2nd groupattack
    level;              // shows which level player is on
    n_ships;            // total number of ships
    extend;             // is either false/true depending score exceed n_extend
    n_extend;           // add 4000 to itself when score is over n_extend
    player_onscreen;    // checks if player is onscreen or not
    reverse;            // is false/true depending on rack's position
    level_end;          // checks if all aliens are dead
    shoot_level;        // :$

//  ---------------------------------------------------------------------------
//  sound identifiers
//  ---------------------------------------------------------------------------
    s_expl;
    s_shoot;            // plays sound for releasing missile
    s_extra;            // plays sound for extra ship
    s_laser2;
    s_laser3;
    s_expl1;
    s_expl2;            // plays sound when player is hit
    s_hit;              // plays sound when alien is hit
    s_begin;            // plays music when game begins
    s_intro;            // plays attract music
    s_attack;           // plays attack sound
    s_gameover;         // plays game-over music
    channel1;           // extra sound identifier

    STRUCT alien_setup[46]
        nr;
        x;
        y;
    END =   45,232,70,44,215,70,43,198,70,42,183,70,41,168,70,40,151,70,
            39,134,70,38,118,70,37,103,70,36, 88,70,35,232,58,34,215,58,
            33,198,58,32,183,58,31,168,58,30,151,58,29,134,58,28,118,58,
            27,103,58,26, 88,58,25,232,46,24,215,46,23,198,46,22,183,46,
            21,168,46,20,151,46,19,134,46,18,118,46,17,103,46,16, 88,46,
            15,215,34,14,198,34,13,183,34,12,168,34,11,151,34,10,134,34,
             9,118,34, 8,103,34, 7,198,22, 6,183,22, 5,168,22, 4,151,22,
             3,134,22, 2,118,22, 1,183,10, 0,134,10;

    STRUCT wave1[9]
        x;
        y;
    END =    95, 44, 74, 23,44, 23,22, 45, 22, 79,
            123,117,123,136,96,150,96,174,133,198;


    STRUCT wave2[9]
        x;
        y;
    END =   202, 44,223, 23,256, 23,227, 44,227, 84,
            190,117,190,136,217,150,217,174,180,199;


    STRUCT wave3[16]
        x;
        y;
    END =    83, 45, 70, 32, 42, 32, 27, 47, 27, 94, 97,126,139,126,153,140,153,154,
            141,166,124,166,111,153,111,135,121,125,147,121,169,143,169,198;

    STRUCT wave4[16]
        x;
        y;
    END =   212, 45,227, 29,253, 29,271, 47,271, 95,193,126,156,127,141,141,141,155,
            158,172,183,172,196,159,196,136,180,120,155,120,134,141,134,199;

LOCAL
    angle1;
    angle2;
    animation;
    id2;
    id3;
    id4;
    _cnumber;
    _dnumber;
    gamestate;
    prev_angle1;

PRIVATE
    _quit;

BEGIN
    set_mode(m320x200);

    file1=load_fpg("fpg\gala.fpg");
    font1=load_fnt("fnt\galaxian.fnt");
    font2=load_fnt("fnt\galafont.fnt");

    load("hiscore.dat", offset highscore);

    s_expl    =load_pcm("pcm\library\war\explosio\explos01.pcm",0);
    s_shoot   =load_pcm("pcm\shoot.pcm",0);
    s_extra   =load_pcm("pcm\xtragun.pcm",0);
    s_laser2  =load_pcm("pcm\eshot.pcm",0);
    s_laser3  =load_pcm("pcm\28.pcm" ,0);
    s_expl1   =load_pcm("pcm\bang.pcm",0);
    s_expl2   =load_pcm("pcm\library\war\explosio\explos11.pcm",0);
    s_hit     =load_pcm("pcm\chit.pcm",0);
    s_begin   =load_pcm("pcm\bstage.pcm",0);
    s_intro   =load_pcm("pcm\galaga.pcm",0);
    s_attack  =load_pcm("pcm\fly.pcm",0);
    s_gameover=load_pcm("pcm\gal90_go.pcm",0);

    put(file1,200,160,50);
    write(font2, 10,100,0,"T h i s  g a m e  i s  p r o g r a m m e d   f o r  t h e  R e m a k e   C o m p e t i t i o n  i s s u e d   b y  F a s t t r a k .");
    write(font2, 10,110,0,"P r o g r a m m i n g  a n d   G r a p h i c s  b y  P e t e r  v a n  D a l e n");
    write(font2, 10,120,0,"G a m e c o n t r o l s :");
    write(font2, 10,130,0,"K e y  L e f t   ");
    write(font2, 10,140,0,"K e y  R i g h t ");
    write(font2, 10,150,0,"K e y  S p a c e ");
    write(font2, 80,130,0,"-  M o v e  L e f t");
    write(font2, 80,140,0,"-  M o v e  R i g h t");
    write(font2, 80,150,0,"-  S h o o t");
    write(font2, 10,165,0,"T o  s t a r t   t h e  g a m e ,  p r e s s  s p a c e ");
    write(font2, 10,175,0,"T o  p r e s e r v e   t h e   a u t h e n t i c i t y   o f   t h e   g a m e   t h i s   s c r e e n   w i l l   o n l y");
    write(font2, 10,185,0,"a p p e a r   a t   s t a r t u p " );
    timer[1]=0;
    fade_on();
    WHILE (fading);
        FRAME;
    END
    REPEAT
        IF (key(_f10));
            highscore=10000;
            save("hiscore.dat",offset highscore, sizeof(highscore));
        END
        FRAME;
    UNTIL (timer[1]>2000 OR key(_space))
    fade_off();
    WHILE (fading);
        FRAME;
    END
    clear_screen();
    delete_text(all_text);
    define_region(1,0,16,320,184);
    start_scroll(0,file1,203,202,1,15);
    scroller();
    banner4(160,4,106);
    banner4( 15,4,107);
    rack(160,70);
    LOOP
        write_int(font1, 20,3,0, offset score);
        write_int(font1,160,3,0, offset highscore);
        fade_on();
        WHILE (fading);
            FRAME;
        END
        channel1=sound(s_intro,128,256);
        groupattack1=false;
        groupattack2=false;
        player_onscreen=true;
        credits=0;
        score=0;
        n_aliens=0;
        n_attacks=0;
        n_ships=max_ships;
        n_extend=4000;
        level=1;
        level_end=false;
        shoot_level=325;
        banner (160, 26,101);
        banner (160, 36,102);
        banner (160, 91,100);
        banner (160,161,  1);
        banner2( 36,195,103,104);
        banner3(160,180,105,0);
        REPEAT
            FRAME;
        UNTIL (key(_space));
        stop_sound(channel1);
        delete_text(all_text);
        write_int(font1, 20,  3,0, offset score);
        write_int(font1,160,  3,0, offset highscore);
        write_int(font2,290,190,0, offset level);
        credits=1;
        fade_off();
        WHILE (fading);
            FRAME;
        END
        REPEAT
            level_end=false;
            sound(s_begin,128,256);
            signal(TYPE banner,s_kill);
            signal(TYPE banner3,s_kill);
            player(160,220);
            _alien_setup();
            tries( 5,180,1);
            tries(17,180,2);
            tries(29,180,3);
            tries(41,180,4);
            tries(53,180,5);
            level_flag();
            IF (level==1)
                timer[3]=0;
                banner(160,100,112);
            END
            fade_on();
            WHILE (fading);
                FRAME;
            END
            REPEAT
                IF (player_onscreen)
                    IF (n_aliens>0 AND n_aliens<6)
                        max_attacks=5;
                    ELSE
                        max_attacks=3;
                    END
                ELSE
                    max_attacks=0;
                END
                IF (n_attacks<0)
                    n_attacks=0;
                END
                IF (n_aliens<=0)
                    FRAME(3000);
                    n_aliens=0;
                    level_end=true;
                END
                FRAME;
            UNTIL (level_end OR key(_esc) OR n_ships<=0);
            IF (key(_esc));
                  signal(TYPE alien,s_kill);
                  signal(TYPE alien2,s_kill);
                  signal(TYPE flagship1,s_kill);
                  signal(TYPE flagship2,s_kill);
                  signal(TYPE laser,s_kill);
                  signal(TYPE alien_laser,s_kill);
                  signal(TYPE level_flag,s_kill);
                  _quit=1;
            END
            fade_off();
            WHILE (fading);
                FRAME;
            END
            IF (n_aliens==0)
                level++;
                shoot_level-=10;
                IF (shoot_level<100);
                    shoot_level=100;
                END
            END
            signal(TYPE player,s_kill);
            signal(TYPE level_flag,s_kill);
        UNTIL (n_ships<=0 OR level>100 OR _quit)
        _quit=0;
        signal(TYPE alien,s_kill);
        signal(TYPE alien2,s_kill);
        signal(TYPE flagship1,s_kill);
        signal(TYPE flagship2,s_kill);
        signal(TYPE player,s_kill);
        signal(TYPE laser,s_kill);
        signal(TYPE alien_laser,s_kill);
        signal(TYPE tries,s_kill);
        signal(TYPE level_flag,s_kill);
        delete_text(all_text);
        IF (can_save)
            save("hiscore.dat",offset highscore, sizeof(highscore));
            can_save=false;
        END
        IF (level>100)
            n_ships=1;
            timer[3]=0;
            banner(160,100,130);
            channel1=sound(s_gameover,128,256);
            write_int(font1, 20,3,0, offset score);
            write_int(font1,160,3,0, offset highscore);
            credits=0;
            fade_on();
            WHILE (fading);
                FRAME;
            END
            REPEAT
                FRAME;
            UNTIL (timer[3]>3700 OR key(_space));
            IF (key(_space));
                stop_sound(channel1);
                timer[3]=3700;
            END
            fade_off();
            WHILE (fading);
                FRAME;
            END
            signal(TYPE banner,s_kill);
        END
        IF (n_ships<=0)
            timer[3]=0;
            banner(160,100,119);
            channel1=sound(s_gameover,128,256);
            write_int(font1, 20,3,0, offset score);
            write_int(font1,160,3,0, offset highscore);
            credits=0;
            fade_on();
            WHILE (fading);
                FRAME;
            END
            REPEAT
                FRAME;
            UNTIL (timer[3]>3700 OR key(_space));
            IF (key(_space));
                stop_sound(channel1);
                timer[3]=3700;
            END
            fade_off();
            WHILE (fading);
                FRAME;
            END
            signal(TYPE banner,s_kill);
        END
    END
END
// ----------------------------------------------------------------------------
PROCESS player(x,y);
// ----------------------------------------------------------------------------
BEGIN
    file=file1;
    size=graph_size;
    LOOP
        IF (y>170);
            y-=2;
        END
        IF (key(_left)  AND x>8) x-=4; END
        IF (key(_right) AND x<307) x+=4; END
        IF (key(_space) AND bullet==false)
            IF (fire1==false)
                fire1=true;
                bullet=true;
                sound(s_shoot,128,256);
                laser();
            END
        ELSE
            fire1=false;
        END
        IF (score>highscore);
            highscore=score;
            can_save=true;
        END
        IF (bullet);
            graph=113;
        ELSE;
            graph=114;
        END
        IF (score>n_extend);
            extend=true;
        END
        IF (extend);
            n_ships++;
            sound(s_extra,128,256);
            n_extend+=4000;
            extend=false;
        END
        IF (id2=collision(TYPE alien))
            BREAK;
        ELSE
            IF (id2=collision(TYPE alien2))
                BREAK;
            ELSE
                IF (id2=collision(TYPE flagship1))
                    BREAK;
                ELSE
                    IF (id2=collision(TYPE flagship2))
                        BREAK;
                    ELSE
                        IF (id2=collision(TYPE alien_laser))
                            BREAK;
                        END
                    END
                END
            END
        END
        FRAME;
    END
    sound(s_expl2,200,256);
    explosion(x,y);
    size=0;
    graph=0;
    FRAME(4000);
    reset_player();
END
// ----------------------------------------------------------------------------
// no entries needed
// laser is fired by player
// takes x,y,z values from father
// if colliding with alien:
// first: checks its number          (this is its "_cnumber" : 1 = blue alien
//                                                             2 = purple alien
//                                                             3 = red alien
//                                                             4 = flagship
// second: then it checks its status (this is its "gamestate"):1 = convoy
//                                                             2 = charger
// third: it calculates score according to gamestate
// fourth: IMPORTANT -> if it is attacking (charger)
//                      then the alien in question has added +1 to
//                      the variable "n_attacks" - so, it must subtract
//                      or else there are no more attacks to perform
// ----------------------------------------------------------------------------
PROCESS laser();
// ----------------------------------------------------------------------------
BEGIN
    x=father.x;
    y=father.y-21;
    z=father.z-1;
    graph=115;
    LOOP
        y-=2;
        IF (id2=collision(TYPE alien));
            sound(s_expl1,128,256);
            id2.size=0;
            size=0;
            SWITCH (id2._cnumber)
                CASE (blue_alien):
                    SWITCH (id2.gamestate):
                        CASE (convoy) : points=30; END
                        CASE (charger): points=60; END
                    END
                END
                CASE (purple_alien):
                    SWITCH (id2.gamestate):
                        CASE (convoy) : points=40; END
                        CASE (charger): points=80; END
                    END
                END
            END
            IF (id2.gamestate==charger): n_attacks-- ; END
            explosion(id2.x,id2.y);
            signal(id2,s_kill);
            score+=points;
            bullet=false;
            n_aliens--;
            signal(id,s_kill);
        END
        IF (id2=collision(TYPE alien2));
            sound(s_expl1,128,256);
            id2.size=0;
            size=0;
            SWITCH (id2._cnumber)
                CASE (red_alien):
                    SWITCH (id2.gamestate):
                        CASE (convoy) : points=50; END
                        CASE (charger): points=100; END
                    END
                END
            END
            IF (id2.gamestate==charger);
                n_attacks--;
            END
            explosion(id2.x,id2.y);
            signal(id2,s_kill);
            score+=points;
            bullet=false;
            n_aliens--;
            signal(id,s_kill);
        END
        IF (id2=collision(TYPE flagship1));
            sound(s_expl1,128,256);
            id2.size=0;
            size=0;
            SWITCH (id2._cnumber)
                CASE (flagship):
                    SWITCH (id2.gamestate):
                        CASE (convoy) : points=60; END
                        CASE (charger): points=800; END
                    END
                END
            END
            IF (id2.gamestate==charger);
                n_attacks--;
            END
            groupattack1=false;
            explosion(id2.x,id2.y);
            signal(id2,s_kill);
            score+=points;
            bullet=false;
            n_aliens--;
            signal(id,s_kill);
        END
        IF (id2=collision(TYPE flagship2));
            sound(s_expl1,128,256);
            id2.size=0;
            size=0;
            SWITCH (id2._cnumber)
                CASE (flagship):
                    SWITCH (id2.gamestate):
                        CASE (convoy) : points=60; END
                        CASE (charger): points=800; END
                    END
                END
            END
            IF (id2.gamestate==charger);
                n_attacks--;
            END
            groupattack2=false;
            explosion(id2.x,id2.y);
            signal(id2,s_kill);
            score+=points;
            bullet=false;
            n_aliens--;
            signal(id,s_kill);
        END
        IF (out_region(id,0));
            BREAK;
        END
        FRAME(50);
    END
    bullet=false;
END
// ----------------------------------------------------------------------------
// entries
// x - x-coordinate
// y - y-coordinate
// c_number - type of alien
//            1 = blue alien
//            2 = purple alien
//            3 = red alien
//            4 = flagship
// d_number - number of destination on rack process
// ----------------------------------------------------------------------------
PROCESS alien (x,y,c_number,d_number);
// ----------------------------------------------------------------------------
PRIVATE
    max_t_wave;
    n_wave;
    t_wave;
    teller;
    x_rotate;
    relx;
BEGIN
    region=1;
    _cnumber=c_number;
    _dnumber=d_number;
    y-=descend;
    LOOP
        flags=0;
        angle=0;
        gamestate=convoy;
        REPEAT
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (x<>alien_setup[d_number].x)
                IF (x<alien_setup[d_number].x)
                    x+=1;
                ELSE
                    x-=1;
                END
            END
            IF (y<>alien_setup[d_number].y)
                IF (y<alien_setup[d_number].y)
                    y+=1;
                ELSE
                    y-=1;
                END
            END
            FRAME(50);
        UNTIL (x==alien_setup[d_number].x AND y==alien_setup[d_number].y);
        LOOP
            gamestate=convoy;
            x=alien_setup[d_number].x;
            y=alien_setup[d_number].y;
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (player_onscreen)
                IF (rand(0,shoot_level)==1);
                    alien_laser();
                    sound(s_laser2,128,256);
                END
                IF (rand(0,50)==0 AND n_attacks<max_attacks);
                    BREAK;
                END
            END
            FRAME;
        END
        n_attacks++;
        gamestate=charger;
        sound(s_attack,128,256);
/*      IF (reverse)
            IF (rand(0,1)==0)
                n_wave=_wave2;
                max_t_wave=9;
            ELSE
                n_wave=_wave4;
                max_t_wave=16;
            END
        ELSE
            IF (rand(0,1)==0)
                n_wave=_wave1;
                max_t_wave=9;
            ELSE
                n_wave=_wave3;
                max_t_wave=16;
            END
        END        */
        t_wave=0;
        teller=0;
        flags=2;
        relx=x;
        x_rotate=0;
        REPEAT
            teller++;
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
/*          SWITCH(n_wave):
                CASE (_wave1):
                    angle2=fget_angle(x,y,wave1[t_wave].x,wave1[t_wave].y);
                    IF (fget_dist(x,y,wave1[t_wave].x,wave1[t_wave].y)<2)
                        teller=0;
                        t_wave++;
                    END
                END
                CASE (_wave3):
                    angle2=fget_angle(x,y,wave3[t_wave].x,wave3[t_wave].y);
                    IF (fget_dist(x,y,wave3[t_wave].x,wave3[t_wave].y)<2)
                        teller=0;
                        t_wave++;
                    END
                END
                CASE (_wave2):
                    angle2=fget_angle(x,y,wave2[t_wave].x,wave2[t_wave].y);
                    IF (fget_dist(x,y,wave2[t_wave].x,wave2[t_wave].y)<2)
                        teller=0;
                        t_wave++;
                    END
                END
                CASE (_wave4):
                    angle2=fget_angle(x,y,wave4[t_wave].x,wave4[t_wave].y);
                    IF (fget_dist(x,y,wave4[t_wave].x,wave4[t_wave].y)<2)
                        teller=0;
                        t_wave++;
                    END
                END
            END
            IF (teller>150 AND t_wave<max_t_wave)
                t_wave++;
                teller=0;
            END
            angle1=near_angle(angle1,angle2,15000);
            x+=get_distx(angle1,2);
            y+=get_disty(angle1,2);
*/
            IF (x_rotate<80);
                x_rotate+=4;
            END
            x=relx+get_distx(angle1,x_rotate);
            y+=1;
            angle1+=3500;
            IF (rand(0,shoot_level/2)==0);
                alien_laser();
                sound(s_laser2,128,256);
            END
//          IF (x>relx)
//              angle=+45000;
//          ELSE
//              angle=-45000;
//          END
            FRAME;
        UNTIL (y>150 OR player_onscreen==false);
        angle=0;
        REPEAT
            y+=2;
            FRAME;
        UNTIL (y>220 OR player_onscreen==false);
        y-=320;
        n_attacks--;
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// entries
// x - x-coordinate
// y - y-coordinate
// c_number - type of alien
//            1 = blue alien
//            2 = purple alien
//            3 = red alien
//            4 = flagship
// d_number - number of destination on rack process
// ----------------------------------------------------------------------------
PROCESS alien2(x,y,c_number,d_number);
// ----------------------------------------------------------------------------
BEGIN
    region=1;
    _cnumber=c_number;
    _dnumber=d_number;
    y-=descend;
    LOOP
        flags=0;
        gamestate=convoy;
        REPEAT
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (x<>alien_setup[d_number].x)
                IF (x<alien_setup[d_number].x)
                    x+=1;
                ELSE
                    x-=1;
                END
            END
            IF (y<>alien_setup[d_number].y)
                IF (y<alien_setup[d_number].y)
                    y+=1;
                ELSE
                    y-=1;
                END
            END
            FRAME(50);
        UNTIL (x==alien_setup[d_number].x AND y==alien_setup[d_number].y);
        LOOP
            gamestate=convoy;
            x=alien_setup[d_number].x;
            y=alien_setup[d_number].y;
            IF (player_onscreen)
                IF (rand(0,shoot_level)==1);
                    alien_laser();
                    sound(s_laser2,128,256);
                END
                IF (_dnumber==43 OR _dnumber==41)
                    IF (groupattack1);
                        n_attacks++;
                        BREAK;
                    END
                END
                IF (_dnumber==40 OR _dnumber==38);
                    IF (groupattack2);
                        n_attacks++;
                        BREAK;
                    END
                END
                IF (rand(0,50)==0 AND n_attacks<max_attacks);
                    n_attacks++;
                    BREAK;
                END
            END
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            FRAME;
        END
        gamestate=charger;
        sound(s_attack,128,256);
        id3=get_id(TYPE player);
        IF (id3<>0);
            angle1=fget_angle(x,y,id3.x,id3.y);
        END
        flags=2;
        REPEAT
            IF (id3<>0 AND y<rim)
                angle1=fget_angle(x,y,id3.x,id3.y);
                angle2=near_angle(angle2,angle1,2000);
                x+=get_distx(angle2,4);
                y+=get_disty(angle2,4);
                prev_angle1=angle2;
            ELSE
                y+=4;
                angle2=prev_angle1;
            END
            IF (rand(0,shoot_level/2)==1);
                alien_laser();
                sound(s_laser2,128,256);
            END
            FRAME;
        UNTIL (y>220 OR player_onscreen==false);
        y-=320;
        n_attacks--;
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// entries
// x - x-coordinate
// y - y-coordinate
// c_number - type of alien
//            1 = blue alien
//            2 = purple alien
//            3 = red alien
//            4 = flagship
// d_number - number of destination on rack process
// ----------------------------------------------------------------------------
PROCESS flagship1(x,y,c_number,d_number);
// ----------------------------------------------------------------------------
BEGIN
    region=1;
    _cnumber=c_number;
    _dnumber=d_number;
    y-=descend;
    LOOP
        flags=0;
        gamestate=convoy;
        REPEAT
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (x<>alien_setup[d_number].x)
                IF (x<alien_setup[d_number].x)
                    x+=1;
                ELSE
                    x-=1;
                END
            END
            IF (y<>alien_setup[d_number].y)
                IF (y<alien_setup[d_number].y)
                    y+=1;
                ELSE
                    y-=1;
                END
            END
            FRAME(50);
        UNTIL (x==alien_setup[d_number].x AND y==alien_setup[d_number].y);
        LOOP
            gamestate=convoy;
            x=alien_setup[d_number].x;
            y=alien_setup[d_number].y;
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (player_onscreen)
                IF (rand(0,shoot_level)==1);
                    alien_laser();
                    sound(s_laser2,128,256);
                END
                IF (rand(0,50)==0 AND n_attacks<max_attacks);
                    BREAK;
                END
            END
            FRAME;
        END
        n_attacks++;
        groupattack1=true;
        gamestate=charger;
        sound(s_attack,128,256);
        id3=get_id(TYPE player);
        IF (id3<>0)
            angle1=fget_angle(x,y,id3.x,id3.y);
        END
        flags=2;
        REPEAT
            IF (id3<>0 AND y<rim)
                angle2=near_angle(angle2,angle1,2000);
                x+=get_distx(angle2,4);
                y+=get_disty(angle2,4);
                prev_angle1=angle2;
            ELSE
                y+=4;
                angle2=prev_angle1;
            END
            IF (rand(0,shoot_level/2)==1);
                alien_laser();
                sound(s_laser2,128,256);
            END
            FRAME;
        UNTIL (y>220 OR player_onscreen==false);
        y-=320;
        n_attacks--;
        groupattack1=false;
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// entries
// x - x-coordinate
// y - y-coordinate
// c_number - type of alien
//            1 = blue alien
//            2 = purple alien
//            3 = red alien
//            4 = flagship
// d_number - number of destination on rack process
// ----------------------------------------------------------------------------
PROCESS flagship2(x,y,c_number,d_number);
// ----------------------------------------------------------------------------
BEGIN
    region=1;
    _cnumber=c_number;
    _dnumber=d_number;
    y-=descend;
    LOOP
        flags=0;
        gamestate=convoy;
        REPEAT
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (x<>alien_setup[d_number].x)
                IF (x<alien_setup[d_number].x)
                    x+=1;
                ELSE
                    x-=1;
                END
            END
            IF (y<>alien_setup[d_number].y)
                IF (y<alien_setup[d_number].y)
                    y+=1;
                ELSE
                    y-=1;
                END
            END
            FRAME(50);
        UNTIL (x==alien_setup[d_number].x AND y==alien_setup[d_number].y);
        LOOP
            gamestate=convoy;
            x=alien_setup[d_number].x;
            y=alien_setup[d_number].y;
            SWITCH (c_number):
                CASE (blue_alien):
                    graph=blue_alien_anim[animation++];
                    IF (animation==sizeof(blue_alien_anim))
                        animation=0;
                    END
                END
                CASE (purple_alien):
                    graph=purple_alien_anim[animation++];
                    IF (animation==sizeof(purple_alien_anim))
                        animation=0;
                    END
                END
                CASE (red_alien):
                    graph=red_alien_anim[animation++];
                    IF (animation==sizeof(red_alien_anim))
                        animation=0;
                    END
                END
                CASE (flagship):
                    graph=120;
                END
            END
            IF (player_onscreen)
                IF (rand(0,shoot_level)==1);
                    alien_laser();
                    sound(s_laser2,128,256);
                END
                IF (rand(0,50)==0 AND n_attacks<max_attacks);
                    BREAK;
                END
            END
            FRAME;
        END
        n_attacks++;
        groupattack2=true;
        gamestate=charger;
        sound(s_attack,128,256);
        id3=get_id(TYPE player);
        IF (id3<>0);
            angle1=fget_angle(x,y,id3.x,id3.y);
        END
        flags=2;
        REPEAT
            IF (id3<>0 AND y<rim)
                angle1=fget_angle(x,y,id3.x,id3.y);
                angle2=near_angle(angle2,angle1,2000);
                x+=get_distx(angle2,4);
                y+=get_disty(angle2,4);
                prev_angle1=angle2;
            ELSE
                y+=4;
                angle2=prev_angle1;
            END
            IF (rand(0,shoot_level/2)==1);
                alien_laser();
                sound(s_laser2,128,256);
            END
            FRAME;
        UNTIL (y>220 OR player_onscreen==false);
        y-=320;
        groupattack2=false;
        n_attacks--;
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// this is a (very) simple one
// laser is fired by alien
// continues going down until it is off the screen
// ----------------------------------------------------------------------------
PROCESS alien_laser();
// ----------------------------------------------------------------------------
BEGIN
    x=father.x;
    y=father.y+4;
    z=father.z+1;
    graph=118;
    REPEAT
        y+=4;
        FRAME;
    UNTIL (out_region(id,0));
END
// ----------------------------------------------------------------------------
// this process performs a procedure that moves the x-coordinates of the
// alien_setup structure
// the priority is lower than that of the aliens, because they must
// find their place inside the rack according to the number given to
// them by the alien_setup process and the alien_setup structure
// ----------------------------------------------------------------------------
PROCESS rack(x,y);
// ----------------------------------------------------------------------------
PRIVATE
    incx=1;
    _counter;
BEGIN
    priority=2;
//  graph=201;
    FRAME(3000);
    FROM _counter = 46 to 0 step -1;
        alien_setup[_counter].y+=20;
    END
    LOOP
        IF (x<120 OR x>200);
            incx=-incx;
        END
        IF (x>190);
            reverse=false;
        ELSE
            reverse=true;
        END
        x+=incx;
        FROM _counter = 46 to 0 step -1;
            alien_setup[_counter].x+=incx;
        END
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// this process uses the alien_setup structure to put all the aliens on the
// screen. The values that are given to the aliens are their actual destination
// points. The alien processes modify their y-values themselves, so that they
// are put off_screen and move downwards in a wave-like fashion.
// the "total_aliens" part is a constant BTW.
// ----------------------------------------------------------------------------
PROCESS _alien_setup();
// ----------------------------------------------------------------------------
BEGIN
    next_alien=total_aliens;
    REPEAT
        SWITCH (alien_setup[next_alien].nr)
            CASE 16..46: alien(alien_setup[next_alien].x,alien_setup[next_alien].y,blue_alien,next_alien)   ; END
            CASE  8..15: alien(alien_setup[next_alien].x,alien_setup[next_alien].y,purple_alien,next_alien) ; END
            CASE  2.. 7: alien2(alien_setup[next_alien].x,alien_setup[next_alien].y,red_alien,next_alien)   ; END
            CASE      1: _flag2=flagship2(alien_setup[next_alien].x,alien_setup[next_alien].y,flagship,next_alien) ; END
            CASE      0: _flag1=flagship1(alien_setup[next_alien].x,alien_setup[next_alien].y,flagship,next_alien) ; END
        END
        next_alien--;
        n_aliens++;
        FRAME;
    UNTIL(next_alien<0);
END
// ----------------------------------------------------------------------------
// banner processes are used to put a graph on the screen with various texts
// the reason I did it this way, is because I did not have the time to put
// all the different letters and numbers into a font. .... So there  :)
// ----------------------------------------------------------------------------
PROCESS banner(x,y,graph);
// ----------------------------------------------------------------------------
BEGIN
    IF (graph==1);
        graph=rand(109,111);
    END
    IF (graph==200);
        size=50;
    END
    LOOP
        IF (graph==119);
            IF (timer[3]>3700);
                signal(id,s_kill);
            END
        END
        IF (graph==112);
            IF (timer[3]>300);
                signal(id,s_kill);
            END
        END
        FRAME;
    END
END
// ----------------------------------------------------------------------------
PROCESS banner2(x,y,graph1,graph2);
// ----------------------------------------------------------------------------
BEGIN
    LOOP
        IF (credits==0);
            graph=graph1;
        ELSE
            graph=graph2;
        END
        FRAME;
    END
END
// ----------------------------------------------------------------------------
PROCESS banner3(x,y,graph1,_timer);
// ----------------------------------------------------------------------------
BEGIN
    timer[_timer]=0;
    LOOP
        IF (timer[_timer]>50 AND timer[_timer]<100)
            graph=graph1;
        ELSE
            graph=0;
        END
        IF (timer[_timer]>100);
            timer[_timer]=0;
        END
        FRAME;
    END
END
// ----------------------------------------------------------------------------
PROCESS banner4(x,y,graph);
// ----------------------------------------------------------------------------
BEGIN
    LOOP
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// processes do not come simpler than this, do they?
// all it does is:
// move the black scroll (scroll[0].y0) two pixel upwards
// move the coloured scroll (scroll[0].y1 one pixel upwards
// et voila: one moving starfield complete with happy twinkly stars
// ----------------------------------------------------------------------------
PROCESS scroller();
// ----------------------------------------------------------------------------
BEGIN
    LOOP
        scroll[0].y0-=2;
        scroll[0].y1-=1;
        FRAME;
    END
END
// ----------------------------------------------------------------------------
//  makes sure that player is not on-screen
//  subtracts 1 from remaining ships
//  if it is still above zero, it calls a ship
//  sets player_onscreen to 1 to indicate that player is onscreen
// ----------------------------------------------------------------------------
PROCESS reset_player();
// ----------------------------------------------------------------------------
BEGIN
    fade_off();
    WHILE (fading);
        FRAME;
    END
    player_onscreen=false;
//  stop_sound(all_sound);
    signal(TYPE alien_laser,s_kill);
    signal(TYPE laser,s_kill);
    bullet=false;
    n_ships--;
    IF (n_ships>0);
        player(160,220);
    END
    fade_on();
    WHILE (fading);
        FRAME;
    END
    FRAME(3000);
    player_onscreen=true;
END
// ----------------------------------------------------------------------------
//  this process displays a small ship
//  if the remaining number of ships is
//  above a certain number, else it displays nothing
// ----------------------------------------------------------------------------
PROCESS tries(x,y,n_tries);
// ----------------------------------------------------------------------------
BEGIN
    LOOP
        IF (n_ships=>n_tries)
            graph=116;
        ELSE
            graph=0;
        END
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// the obligatory explosion process
// ----------------------------------------------------------------------------
PROCESS explosion(x,y);
// ----------------------------------------------------------------------------
BEGIN
    FROM graph=400 to 412;
        FRAME;
    END
END
// ----------------------------------------------------------------------------
// flag for level
// ----------------------------------------------------------------------------
PROCESS level_flag();
BEGIN
    x=310;
    y=192;
    graph=117;
    LOOP
        FRAME;
    END
END
// are we done already? - sheesh, 1396 lines of code
