//Program:Quadzle
//Version:1.0
//Written by MadMax       E.J.Urbano Comyns-Carr
//Story:Based on the classic TETRIS. Many people have mentioned this game
//on the forums; so I thought I'd give it a try. I must confess, I thought
//it would be quite easy. But actually it presents some interesting problems
//At first I thought I would rotate the blocks with angle, but it spoilt the
//graphics and presented some problems with the control point.
Program Quadzle;
const
avan=21;//How many pixels the block moves each turn.(down,left,right)
global
reloj=50;//controls the speed
idbujos;//for use with the FPG
rpc;//checks that the control key has been released.
comp;//checks how far the block has fallen.
soncae;//These three are for use with the sounds.
sonblock;
sonline;
sigfig;//stores the next figure to appear.
score;//Mm... er...
scheck;//Keeps a partial score to decide when to increase the level.
bfont,sfont;//for use whith the fonts.
begin
set_mode(m640x480);
idbujos=load_fpg("quadzle\quad.fpg");
soncae=load_pcm("quadzle\avant.wav",0);
sonblock=load_pcm("quadzle\block.wav",0);
sonline=load_pcm("quadzle\line.wav",0);
bfont=load_fnt("quadzle\seabig.fnt");
sfont=load_fnt("quadzle\sea.fnt");
put_screen(idbujos,100);
set_fps(80,0);//set number of frames per second.
write_int(bfont,400,40,0,offset score);//prints the score.
frame;
restore_type=partial_restore;//now this is one of my favourite instructions
//normally on my old pentium 150 I'm lucky if I get over 20 fps.
//now with this & dump_type(I don't use it in this program) I can get to
// 100 fps (Who needs a pentium III? - Sour grapes? Me?).
//The only thing is to use this whith care, as you can get strange graphic
//effects.
sigfig=rand(1,7);//Chooses the next figure to appear, which is the first.
select();//Calls the process.
end//Bye,bye process.

process select();
private
sig;
begin
sig=sigfig;//Makes the next figure be the one that is falling.
frame;
switch(sig)     //Here we call the process that controls how the figures
    case 1:     //fall. The first value is the first graphic and the second
    plana(1,2); //the last. This varies with the figures as some need more
    end         //graphics than others; the square only needs one.
    case 2:
    plana(3,3);
    end
    case 3:
    plana(4,7);
    end
    case 4:
    plana(8,11);
    end
    case 5:
    plana(12,13);
    end
    case 6:
    plana(14,15);
    end
    case 7:
    plana(16,19);
    end
end
//Here we print the next graphic on the screen. Notice that we change the
//restore_type to print the graphics properly. This of course slows down
//the fps, but only a fraction of a second (2 frames) in a non-critical
//part of the program.
restore_type=complete_restore;
put(idbujos,30,390,400);//Places a black square to erase the previous graphic.
frame;//We refresh the screen.
sigfig=rand(1,7);//We choose the next graphic.
put(idbujos,sigfig+20,390,400);//Places the next graphic on the screen.
frame;//We refresh the screen.
restore_type=partial_restore;//We go back into fast mode.
end//bye, bye process.

//The following process controls the falling block
process plana(sgraf,egraf)
private
sgraf;//The first graph for the current block
egraf;//The last graph for the current block.
      //This way we control the seven posible blocks, with only
      //one process.


//Every block has 4 control points from 0 to 3, with these we check
//if it has reached the bottom or has collided with a previous block.
//Control point 0 is also used by the system to place the graph.
punto;//control point number.
puntx;//x coords for control point.
punty;//The same for y.
ocu;//If its value is greater than 0 the block:
                                    //A. Has reached the bottom.
                                    //B. Has collided with another block
                                    //C. Is trying to go through a side-wall.

crono;//reloj controls the general speed at which blocks fall, but when the
      //_down key is pressed the blocks fall faster and then when its released
      //the block continues to fall at the previous speed(This varies along
      //the game. So we need to store the previous value).
n;//used in the for loop.
begin
crono=reloj;//stores the current speed
graph=sgraf;//sets the graph.
x=184;y=18;
timer=0;//The timer is used in combination with reloj. To set the speed at
        //at which the blocks fall.
loop
frame;
//Every... The block falls.
if(timer=>reloj)
y+=avan;timer=0;
//Checks if it collides. If yes it goes to the end of the process.
//If not it plays a falling sound. The for loop makes the sound louder.
from punto=0 to 3;
get_real_point(punto,offset puntx,offset punty);
if(get_pixel(puntx,punty)>1)ocu++;end
end
if(ocu>0)break;break;end
for(n=1;n<2;n++)
sound(soncae,512,256);
end
end
//Rotates the block. Checks if it collides with anything; if so
//it doesn't rotate.
if(key(_control) and rpc==0)
rpc=1;graph++;
if(graph>egraf)graph=sgraf;end
from punto=0 to 3;
get_real_point(punto,offset puntx,offset punty);
if(get_pixel(puntx,punty)>1)ocu++;end
end
if(ocu>0)graph--;if(graph<sgraf)graph=egraf;end;ocu=0;end
end
//Moves left. checks as above. The timer is so the block doesn't move to fast.
if(key(_left) and timer[1]>10)
x-=avan;
from punto=0 to 3;
get_real_point(punto,offset puntx,offset punty);
if(get_pixel(puntx,punty)>1)ocu++;end
end
if(ocu>0)x+=avan;ocu=0;end
timer[1]=0;
end
//Moves right. Bla,bla...
if(key(_right) and timer[1]>10)
x+=avan;
from punto=0 to 3;
get_real_point(punto,offset puntx,offset punty);
if(get_pixel(puntx,punty)>1)ocu++;end
end
if(ocu>0)x-=avan;ocu=0;end
timer[1]=0;
end
//While the down key is pressed the blocks fall ten times faster.
if(key(_down))reloj=crono/10;else reloj=crono;end
if(not key(_control))rpc=0;end//Checks we aren't pressing _control.
end
//End of loop
sound(sonblock,256,256);//Plays a sound for placing the block.
map_put(idbujos,100,graph,x,y-avan);//Places the block in a control map
put(idbujos,graph,x,y-avan);//Places the block on the screen.
if(y-avan=<18)
newgame();//Ends game
else
//Below adds the score. If falling fast or normal.
if(reloj==crono/10)score+=100;scheck+=100;else;score+=50;scheck+=50;end
comp=y-avan;//So linecheck knows where the block is.
reloj=crono;//resets value to reloj.
linecheck();
end
end

//This process basically checks if any lines have been completed. Makes
//the line dissapear and scrolls the blocks down. Updates the score and
//calls the nest block.

process linecheck()
private
line;
destx=174,desty,desty1;
ancho=210,alto,alto1;
corr;
four;
plos;
scount;
begin
restore_type=complete_restore;//We reset the restore_type
//We check 4 lines from bottom to top. This is because the maximun
//hight for a block is four bricks.
for(four=1;four<5;four++)
from x=79 to 268 step 21; //each brick is 21 pixels wide.
if(get_pixel(x,comp)>1)line++;end//if the screen colour is > 1 there is a brick.
end
if(line==10)//So if line is worth ten we have a line.
sound(sonline,64,256);//we play a sound
scount++; //This is to calculate the score
for(plos=50;plos<56;plos++)//Graphic to indicate a line has been made.
y=comp;x=174;
graph=plos;
frame;
end
//Here we copy the graphics above the line to a blank map (102)
alto1=comp-50;
map_block_copy(idbujos,102,69,39,100,69,39,ancho,alto1);
//Here we paint a blank square to erase the line and all above it.
alto=comp+10;corr=224-(alto/2);desty=(alto/2)-corr;
map_put(idbujos,100,101,destx,desty);
//Here we put the graphics we copied to 102 back on the screen a line lower.
map_block_copy(idbujos,100,69,60,102,69,39,ancho,alto1);
put_screen(idbujos,100);
frame;
else
comp-=avan;//If no line we check the line above.
end
line=0;//reset
end //We repeat the process four times.
restore_type=partial_restore;//back to fast restore_type.
frame;
//Calculate the score depending on the lines made.
score=score+(500*scount);scheck=scheck+(500*scount);
//Scheck decides if we increase the speed, depending on the score.
if(scheck=>2000)scheck-=1000;reloj-=2;end
select();//next block
end

//We are sent here when the game finishes. We unload the fpg and load it
//again because it has been corrupted by the previous game. Possibly
//it would be more elegant to restore the graphics, but this system works well
process newgame()
begin
restore_type=complete_restore;
put(idbujos,30,390,400);
put(idbujos,103,175,300);
unload_fpg(idbujos);
idbujos=load_fpg("mio\fpg\quad.fpg");
loop
if(key(_esc))exit("Thanks for playing.",0);end
if(key(_space))break;end
frame;
end
reloj=50;score=0;scheck=0;
put_screen(idbujos,100);
frame;
restore_type=partial_restore;
sigfig=rand(1,7);
select();
end

//That's all. Of course there is room for much improvement. So feel free to
//experiment with the code
//                              MadMax 007