// Flak 1.0 sourcecode
// produced by Tariq H. Walji using DIV Games Studio
// Graphics by Tariq H. Walji
// Sounds used from the DIV Games Studio library
//
// Thanks for downloading my game, you probably downloaded it for this
// sourcecode. Well, here it is. As you can see, the first page is already
// full of comments and I think I've gone too far with the comments. All
// I hope now is that if you got help and used any of the techniques
// in your own projects, to give me credit too. It would really help me.
// Mind you, everything here is done is 24 hours! Yeah, 24 hours! So,
// right now.... um ... I'm going to have to go to sleep.
//
// Of course, don't forget to E-MAIL me and tell me what you think!
// tariqwalji@yahoo.co.uk
//
// This is my first DIV Games Studio game, I've programmed in C++ before,
// so you'll find a lot of comments that relate DIV to C++. It ain't
// that different, but to tell you the truth, it removes that extra
// bit of work. Don't be let down because of 740 lines that you see! Its
// full of comments and you might be browsing in no time, making your own
// games. Well, good luck!
//
// Tip: When creating graphics, create them in 16 million colours! Then
//      put all the graphic together, and reduce the pallete down to
//      16 colours. If it goes right, all the 16 million colour joy
//      should remain, and all your sprites/images should be the
//      same pallete!


// we first need to define what the game will be called, this must not
// include any spaces.
PROGRAM flak;


// global variables, or global "containers" can be accessed from anywhere
// within the program. The containers can contain numbers or simple text.
// All variables are stored somewhere in the memory. When the program loads,
// certain ammounts of free memory is used to store variables. DIV does the
// memory management for you so you don't have to. In C++, you could have
// had to declare what type of variable you were creating and how much
// memory you would want to take for the variable.
GLOBAL
    FireWeapon;       // Firing weapon sound
    WeaponMove;       // When left/right keys are pressed sound
    FlakHit;          // When the flak collides with the crate/plane sound
    SoundChannel;     // Sound Channel number 1
    SoundChannel2;    // Sound Channel number 2
    NumberOfPlanes;   // Total number of planes in the field
    MaxPlanes;        // Maximum possible planes in the field
    PlayerScore;      // Player's current score
    TotalCrates;      // Total crates that have been landed
    MainFPG;          // The main game's FPG file
    MenuFPG;          // The menu's FPG file

// Local variables in DIV games studio are unique to all processes. Each
// process has its own set of pre-defined local variables. When a process
// is created, a memory location is allocated for a certain variable,
// unlike global variables which simply are allocated in memory during
// creation and which is shared by other processes throughout the program;
LOCAL
    PlaneDirection;   // A random number that decides which way the plane faces
    SimpleWatt;       // The Y value of the plane's axis
    DistanceType;     // Used by the star field, the further, the slower
    testmatl;         // A temporary field for FOR loops
    TheAngleOfMe;     // An angle value for certain processes
    AngleDirectionz;  // Used to create the crate's alternating angle effect
    DropPoint;        // A random number that decides where the crate is to be dropped
    deathtag;         // A state that determines the process being alive
    currentframez;    // current explosion frame


// This is the main program's loop. In here, everything begins and everything
// ends. Everything is executed here, before focus is given to the other
// processes even if they have been created. Once the END has been reached,
// the processes are given control. If no processes exist, the program
// is shutdown automatically.
BEGIN
    // the video mode is set using a pre-defined constant made by DIV GS
    set_mode(m640x480);


    // We load the game's main FPG file and store the return value to
    // later access. The return value is the file's code, and it is
    // important to always store this just in case. For example, closing
    // a particular FPG file requires you to have this return value. Thats
    // why I've defined it global, so that any process can destroy it.
    MainFPG = load_fpg("flak.fpg");


    // We load the sounds. DIV loads the sounds into memory. The only
    // thing we really need is to know where each sound is stored and
    // that is why we need to store the return value as a sound name.
    // Later on, you can play the sounds using this return value. Never
    // guess using numbers, try to use comprehensive variable names.
    FireWeapon=load_pcm("flakshot.pcm",0);
    WeaponMove=load_pcm("gunmove.pcm",0);
    FlakHit = load_pcm("flakhit.pcm",0);

    // we load up our menu.
    startmenu();

END



// Name: StartMenu();
// Description:
// Destroys all existing processes except itself, unloads the game's
// pallete and FPG file and sets its own. Simply put, its a menu that
// the user can use to play the game or exit.
PROCESS startmenu();
BEGIN

  // we must clear the screen to make sure that there is nothing on
  // the screen that we have created using the put_pixel or anyother
  // drawing functions. If you remove this, play a game then press ESC,
  // you will find that the star's are still there, different coloured
  // (because of the pallete change).
  clear_screen();

  // We also make sure that all other processes are destroyed. This
  // way, the screen should only contain the menu.
  let_me_alone();


  // We try to make sure that our main game's graphics and pallete are
  // unloaded as to load up the menu. This way, you don't get conflicts.
  unload_fpg(mainfpg);

  // we load up the menu's graphics and pallete here. Very simple! You
  // might notice that the pallete is being loaded directly from the
  // FPG file.
  menufpg = load_fpg("flakmenu.fpg");
  load_pal("flakmenu.fpg");


  // Every process has this. Not defining the GRAPH local (notice I say local)
  // variable means the process won't display any graphic. I will demonstrate
  // its use in this project.
  graph=1;


  // The X and Y values are once again local variables. Define is the wrong
  // word to use, because the GRAPH, X and Y variables have been previously
  // assigned and determine how a certain object is drawn. Below, we draw
  // the menu fullscreen. One thing with DIV Games Studio as opposed to
  // C++ is that when you define its position, you define its center
  // position. For example, below the coordinate is 320 x 200. The center
  // of the image should be 320x200 and not the top left! Remember this
  // when setting object positions.
  x = 320;
  y = 240;


  // You might have heard that every game has a loop. That's particularly
  // true. DIV Games Studio is a really great application because each
  // process has a mind of its own. You can have a series of processes
  // defined at the same time. The more times you call a process, the more
  // instances (in simple terms, more of them) will be made. That is also
  // something that you should look out for. It means if you by mistake
  // call startmenu more then once, you have a series of start menus although
  // you might not be able to see them.  Each instance, will have its own
  // X and Y coordinates and its own GRAPH value because its a local
  // variable.

  repeat

    // The thing with DIV Games Studio is that if you do not have a FRAME;
    // command somewhere in the loop, its going to think something
    // terrible is gone wrong and will give you an error. Always have
    // a frame, even if there is no graphic!
    frame;

    // Below, we find out what keys the user has clicked. DIV Games
    // Studio is not case sensitive, so you might be able to get away
    // with the common capital letter error, C++ is not as forgiving.
    // The keyboard's keys are made up of series of codes. Pressing a
    // key sends a specific code to the game. Below, "_down" is a
    // pre-defined constant that stores the code to the down key. The
    // key function takes this and returns a TRUE (1) or a false (0).
    // If true, then it will do whats in between the IF and END. If not,
    // the IF statement will simply be ignored and the program will move on.
    if(key(_down))

      // We use the graph to our advantage to change which selection
      // the user has highlighted. If someone pressed down, check
      // if graph is 1, and if it is simply change it to 2, otherwise
      // we know its 2 and simply change it to 1.
      if(graph==1) graph=2; else graph=1; end;

      // I do not recommend these in the main game. Whenever a loop
      // just keeps on going like this, you see the program stop.
      // In the game, if this were to happen, it would be a disaster.
      repeat
      until(!key(_down));
    end

    // we keep on doing the same things. In all programming languages
    // you will always be forced to repeat things. That's because
    // thats what programming is all about, being specific, just too
    // specific!
    if(key(_up))
      if(graph==1) graph=2; else graph=1; end;
      repeat
      until(!key(_up));
    end

    if(key(_enter))

      // Once again we use graph to our advantage to see what key the
      // user has pressed. This is why planning is so important to many
      // programmers and so is experience. Through time, you will
      // find more shortcuts!
      if(graph==1)
          // Simply put, graphic 1 is the first selection. We now
          // prepare for the user to play the game. We first unload
          // the menu's FPG and load the pallete and FPG of the main
          // game's FPG.
          unload_fpg(menufpg);
          mainfpg = load_fpg("flak.fpg");
          load_pal("flak.fpg");

          // We start off a few processes and let them move on.
          DrawWeapon();         // The ship's main weapon
          DrawBase();           // the half circle base of the weapon
          GenerateEnemy();      // The aircraft generation code
          CreateShipFloor();    // The ship's floor
          break;                // break up the menu's loop and quit process
      end
      if(graph==2)
        // because we haven't loaded any other processes yet, and this is
        // the only process, we use break to break out of the REPEAT
        // loop. Pressing ESCAPE will do the same thing (notice until
        // at the bottom). When there are no processes left to process,
        // the program simply quits. It is advisable to use the EXIT
        // function though.
        break;
      end

    end
  until(key(_esc));
END


// Name: CreateShipFloor();
// Description:
// Create the ship's main floor and update the scene with it. If anything
// overwrites the region, over write it with the ship's scene.
PROCESS CreateShipFloor();
BEGIN
  // as always, we define the graphic and the object position. We also try
  // to move up. Notice 520, when the maximum height is 480? Well,
  // the answer is that we are providing the coordinate of the center
  // of the bitmap!
  graph=7;
  x=320;
  y=520-47;

  // First of all, we create 100 stars. Each star is simply a process! Each
  // process is responsible for 1 star's deletion and addition. To demonstrate
  // that the more times you call a process the more processes of the
  // instance it creates, we call createstars(x,y) 100 times using the
  // for loop. The X and Y are randomly generated using the RAND function.
  // You can always move your cursor (the little flashing dot that allows
  // you to add text) over RAND and press F1. If this was C++, it wouldn't
  // be this easy. You would have to manually create a record for 100
  // stars with their coordinates and adjust each star's coordinate
  // using a loop. The FOR loop in the C++ program will be used for
  // every time you wanted to update the star's coordinates. Not difficult,
  // but time consuming.
  for(testmatl=0; testmatl<100; testmatl++) CreateStars(rand(1,640), rand(1,480), rand(1,3)); end;


  // We simply put the process into a loop so that the floor always shows.
  // Remember, you MUST have a frame other wise the process will simply
  // stop inside this loop and forget about the other processes.
  repeat
    frame;
  until (key(_esc))

END


// Name: GenerateEnemy();
// Description:
// Generates an enemy whenever the number of enemies reaches below
// the maximum number of enemies. This does not include enemies that
// are dying.
PROCESS GenerateEnemy();
BEGIN

  // Most of the time you will be declaring variables at the start
  // of each of your processes. Remember local variables are defined
  // in a separate memory location for every process you have.
  MaxPlanes=5;              // the maximum number of planes
  PlayerScore=0;            // player score, this game doesn't utilise it yet
  numberofplanes=0;         // current number of planes

  // We start a loop up, constantly checking that there are a maximum
  // number of planes and if it goes anywhere below that, create one.
  repeat
    // check if number of planes is below maximum planes.
    if(numberofplanes<maxplanes)
      // if so, from the number of planes to the maximum number of planes ...
      for(numberofplanes=numberofplanes; numberofplanes<maxplanes; numberofplanes++)

        // randomly select from which direction the plane should appear from
        if(rand(0,100)<25) PlaneDirection=1; else PlaneDirection=2; END;

        // and randomly select its height.
        if(rand(0,100)<25) SimpleWatt=30; else if(rand(0,100)>75) SimpleWatt=50; else SimpleWatt=70; end;end;

        // Create the plane.
        CreatePlanes(PlaneDirection, SimpleWatt);
      end
    end

    // As usuall you need this so tell DIV Games Studio to process the other
    // processes before continuing.
    frame;

  until(key(_esc));
END


// Name: CreatePlanes(Direction, Height)
// Description:
// Creates a plan facing a certain direction and maintaining a certain height.
PROCESS CreatePlanes(PDir, y)
BEGIN

  // The plane is not dead!
  deathtag = 0;

  // The plane's direction.
  PlaneDirection = PDir;

  // Where is it going to drop the crate. First is randmly generates a
  // number 1 to 5, then times it by 100, making it anything from 100
  // to 500. Why not just randomly generate from 100 to 500? Well,
  // we want the crates to be apart from each other as much as possible.
  DropPoint = rand(1,5)*100;

  // Set the graphic for the plane (from the FPG file of course).
  graph=5;

  if(PlaneDirection==1)
    // If the PlaneDirection is 1 then set the plane to the left of the
    // screen.
    x=30;

    // Do other processes.
    frame;
  end

  if(PlaneDirection==2)
    // If the plane direction is 2 then set it to the right of the screen.
    // There is a flag also set in this, and all it means is mirror the
    // graphics. "Flags" is also a pre-defined local variable that you
    // can choose to add values to. It simply will modify the graphic
    // in some way.
    flags=1;
    x=630;
    frame;
  end

  // Loop as always
  loop
    frame;

    // We must make sure that the plane is not dead so we can count
    // it as a plane rather then dead-meat.
    if(deathtag==0)
        if(PlaneDirection==1)
          // We move the plane right. Increasing this value to a large
          // scale can have noticable effects, so I recommend keeping
          // the value smaller.
          x += 5;

          // We make sure that the plane does not go off the screen, other-
          // wise count it as a dead plane and break the loop, effectively
          // ending the process and ending that particular plane.
          if(x>640)
            numberofplanes -=1;
            break;
          end;

          // if the X value is on the drop point, then set off the crate!
          // Be carefull! Maths is very important here. The drop point
          // value must be in the multiples of 5. I say this because we
          // move the ship in increments of 5, having another value as
          // the drop point will definitely not work.
          if(x == droppoint) CreateCrates(x, y); end;
        end
        if(PlaneDirection==2)

          // You should be able to figure the rest out.
          x -= 5;
          if(x<1)
            numberofplanes -=1;
            break;
          end
           if(x == droppoint) CreateCrates(x, y); end;

        end


        // Each process has its own ID. You can simply create a process
        // and figure out its own ID, but then there might be hundreds
        // of processes that you'd want to create. Instead, if you want
        // all processes of a certain type, use the type command with
        // the process name. This way, any process named the process
        // name that collides with this process, then take action as
        // you see below.
        if(collision(type FireWeapon1))

          // If you remembered what I said earlier, you'll realise what
          // I've done here. When you loaded the sound, you stored its
          // return value to ID the specific sound. Here, we know
          // where its stored in memory because we know its ID, and so
          // we can play the sound.
          sound(flakhit, 255, 255);

          // We know that the FireWeapon1 process was from the player,
          // so we award the player 1. We also reduce the number of planes.
          // If you remember earlier, we made sure that the number of planes
          // on the screen was maximum. That process will do its job,
          // so we wont have to. In C++, we would have to worry about that
          // here.
          PlayerScore += 100;
          numberofplanes -=1;

          // We declare this process DEAD!
          deathtag = 1;

          // And add some special effects :-)
          create_explosion(x, y);

          // Show the world
          frame;
        end
    else

      // Previously, we made sure that the plane is not dead. Here,
      // we know that the plane is dead because deadtag is set to 1.

      if(planedirection == 1)
        // as always, the player's direction is player a part. We modify
        // the X and Y values to give it a more dramatic feel.
        y = y + 5;
        x = x + 5;

        // And we modify the angle. Surprise, surprise. Angle is also
        // a pre-defined constant. Modify this and you modify the
        // process's graphic. In C++ you would have had to re-apply
        // what you changed, thank you Div!
        angle = angle + 5000;
      end
      if(planedirection == 2)
        y = y + 5;
        x = x - 5;
        angle = angle - 5000;
      end

      // Obviously, we don't want to see the face of this little enemy
      // again, so we break the loop and end the process.
      if(x>640) break; end;
      if(y>480) break; end;
    end
  end
end


// Name: DrawBase();
// Description:
// Draw's the weapon's base. We want it to be slightly more realistic,
// so we hide the nasty weapon with its base, making it more realistic
// rather then a flying weapon. In films, you never see the ship's turrets
// without its base (a great example is star wars).
PROCESS DrawBase();
BEGIN
  graph=2;
  x=320;
  y=500-27-31;

 REPEAT
    frame;
    if(key(_esc))
      // I've done this on purpose. What's wrong with this? Simple, when
      // you press ESCAPE, the loop is going to exit anyway. Why the break?
      // Also, the startmenu() process makes sure its the only process,
      // so why have the base the only process if its going to die anyway.
      let_me_alone();
      break;
    end
  UNTIL (key(_esc))

  // Once we end the loop, we end the game and go back to the menu.
  startmenu();

END


// This is where there will be the least number of comments. Where there
// will be a need for comments, I'll add comments.

PROCESS DrawWeapon();
BEGIN
    graph=1;
    x=320;
    y=500-27-38;


    REPEAT
      frame;
      if(key(_left))
        // You might have noticed we're going up in 1000s! It's not
        // exactly 1000s. Its the angle times by a 1000 to give it
        // more accuracy. I don't see the point, but there's probably
        // some use.
        angle = angle + 3000;
        if(angle>30000) angle=30000; end;
        soundchannel=sound(WeaponMove,128,255);
       frame;
     else
     if(key(_right))
        angle = angle - 3000;
        if(angle<-30000) angle=-30000; end;

        // The loading of sound may have its return value, but when
        // you want to take control over the sound that is playing,
        // you must know its channel number.
        soundchannel=sound(WeaponMove,128,255);
        frame;
      else

        // and this is a great example of where the channel number is used!
        stop_sound(soundchannel);
      end
      end

      if(key(_space))
       FireWeapon1(angle);
      end
    UNTIL (key(_esc))
END


// Name: FireWeapon1(TheAngleToFireAt)
// Description:
// Sets off the main plasma/whatever towards the direction of the
// turret. Its a tricky job because not only do you have to know
// in which direction the turret is facing, but you also have to
// know from where the bullet will start off. I solve the problem
// by using the get_distx and getdisty functions to get the x and
// y of the bullet so that it starts off right at the top of the
// main weapon.
PROCESS FireWeapon1(MyAngle);
BEGIN

// I add 90 degrees to the current angle set by the main gun because
// the main gun's drawing is always facing up while DIV's degree 0 is
// daving right. So we simply just change where the bullet will be
// coming from.
angle=MyAngle+90000;
graph=3;

// You're seeing these minuses and pluses all over the place. This is
// so that we know the edge but we know how far from the edge do we have
// to move to get the calculation right. There are a number of ways
// you can do this, this is just one of them. What I've also done, is
// added to the X and Y the position of the top of the gun, from where
// the shots will be coming from. This way, when the main gun moves left
// or right, the position of where the shots start from is always
// the same.
y=480-27-19+get_disty(angle,55);
x=320+get_distx(angle,55);


// Remember, whenever we play a sound, we must know what channel its
// playing in so that we can shut it down or change it anyway. Its
// very difficult to stop a sound after its started without the
// channel number, so record this!
soundchannel2= sound(FireWeapon,128,255);

REPEAT
  // This command advances or moves forward a number of steps in the
  // direction of the angle. When the user fires, it should keep going
  // up until it hits something or moves out of the screen's border.
  advance(10);

  frame;
UNTIL(y<0 or x<0 or x>640)

stop_sound(soundchannel2);

END


// CreateStars(x, y, distance);
// Description:
// Creates a single star and manages it, starting from the X and Y
// values. The speed of the star as well as the colour depends on
// the distance value, which can be 1 up to 3, 1 being far and 3
// being near. Have a bunch of these far and near stars and you get
// a fully working star field! In C++, you would have to control each
// star manually, and have a record of each star. Here, you simply
// call the process a 100 times, while randomly generating its
// position as well as its distance.
PROCESS CreateStars(x,y,distancetype);
BEGIN

  // Loops as always!
  repeat
    // Notice the following 3 lines. It checks the distance, it uses the
    // put pixel function to place the star on the screen. You might
    // also notice that it uses the put_pixel function again to erase
    // the previous star, according to its speed, effectively also
    // covering its trail.
    if(distancetype==1) put_pixel(x+4, y, 0); put_pixel(x,y,66); x -= 4; end;
    if(distancetype==2) put_pixel(x+3, y, 0); put_pixel(x,y,21); x -= 3; end;
    if(distancetype==3) put_pixel(x+1, y, 0); put_pixel(x,y,4); x -= 1; end;

    // If this was C++, you would have to make sure that this star does
    // not show up on the screen after its moved away from the left side
    // of the screen, otherwise you get that same pixel appearing on the
    // right side. DIV does this error checking for you, so we use it
    // to our advantage. If we remove this, then we get a line of dotted
    // pixels streaming down the left side of the screen. Notice the
    // above code will erase the star 4 pixels to the right of the
    // current one? Now you'll understand why I've put -4.
    if(x<-4) put_pixel(x+1, y, 0); x=640; end;

    // Surprise, surprise!
    frame;
  until(key(_esc));

END


// Name: CreateCrates(x, y);
// Description:
// One of the most interesting techniques you'll find in my code. This
// is the crates falling from the sky, and touching the ground. It
// took a little testing to get the crates to align with the ground,
// but it was worth it.
PROCESS CreateCrates(x, y);
BEGIN

 // as usuall we set the process's graphic.
 graph=4;

 // We find out the current angle of the crate, just in case, although
 // I don't think it was necessary, we could have just put a 0.
 theangleofme = angle;

 // We're going to use a switching technique to move the crate left, to
 // right. Below, we set it so that it goes to the left. If this were
 // two, you would find it going to the left. It would be interesting
 // to see if we randomly select between 1 and 2.
 angledirectionz = 1;

 // The death tag. Sort of like the plane, where we can produce a certain
 // effect to the crate when it dies.
 deathtag=0;

 // We're using a loop here. Scary. There is no difference, just that
 // this one really means a loop and if you can't get out of this one,
 // you're stuck.
 loop
  // As usuall, we make sure that the crate is not dead!
  if(deathtag == 0)

     // Remember what I said earlier. This is the switching mechanism.
     // Basically, if angledirectionz is 1 the move the crate towards
     // the left, otherwise move it to the right. It can get a little
     // confusing after a while, especially with the angle, and what
     // effect the angle will produce.
     if(angledirectionz == 1) theangleofme += 2000; end;
     if(angledirectionz == 2) theangleofme -= 2000; end;

     // We  refresh the crate's angle.
     angle = theangleofme;

     // Now this is the heart of the pivot. If the angle is too far left,
     // then move it right, otherwise if its too far right, move it left.
     // Very, very simple and yet very effective.
     if(angle<-22000) angledirectionz = 1; end;
     if(angle>22000) angledirectionz = 2; end;

     // Of course, what use is a crate that just sits there rotating.
     y = y + 1;

     // We make sure the crate has not touched the ground. This part,
     // is very, very tricky. You need to experiment a few times to
     // get the stationary crate and the falling crate just right.
     // This one works anyways, and we also destroy this falling crate
     // because it should not be stationary.
     if(y>480-27-23) CreateStationaryCrate(x, y); break; end;

     // The first line below makes sure that the crate was not hit by a
     // flak from our main gun, if so, create the nice blue explosion,
     // create the sound, and set deathtag to one. This way, on the next
     // loop cicle, this crate is really history.
     if(collision(type FireWeapon1)) deathtag=1; create_explosion(x, y); sound(flakhit, 128, 255); end;

     // One issue I found out during the testing stage is that you would
     // usually get crates falling behind each other and you really wont
     // be able to know how many crates there really are. This technique,
     // simply makes sure that if theres a crate below the falling crate,
     // consider it a stop.
     if(collision(type CreateStationaryCrate)) CreateStationaryCrate(x, y+5); break; end;
     frame;

   else

     // And of course, this is the death fase. The crate seems to keep falling,
     // till it hits something.
     graph=6;
     y = y + 5;
     if(y>480) break; end;
     frame;
   end
  end

END


// Name: CreateStationaryCrate(x,y);
// Description:
// Creates a stationary crate. You need to do a few bits and pieces here
// too to get the crate aligned with the falling crate, otherwise it
// looks pretty unrealistic.
PROCESS CreateStationaryCrate(x, y);
BEGIN

  // Stationary crate's graphic.
  graph=6;

  // We do a bit of adjusting, wow! You might have noticed, that I
  // do not reference the above X and Y. That's because, the above X and Y
  // are counted as the values for the local variable. In C++, you'd
  // get a bunch of errors.
  y = y+12;

  // We need to know how many crates there are to produce the nice nuke
  // effect. Sorry if you were disappointed, I originally had planned
  // a series of explosions, but 256 colours limited me from adding
  // any reds and yellows :-(
  totalcrates = totalcrates + 1;


  repeat
    frame;

    // We really don't need much here apart from telling the world that
    // we're there and we exist. Of course, this is the nuke effect
    // that I've been talking about.
    if(totalcrates>10)
      // We destroy everything apart from this process. Nice, but of course
      // produces that silly one crate left scene.
      let_me_alone();

      // We use this simple angle variable for something it was not
      // designed for, just a little for loop that counts to 50, each
      // time increasing its fade value by 5.
      for(theangleofme=0; theangleofme<50; theangleofme++)
        fade(200,200,200, 5);
        frame;
      end;
      break;

    end;
  until(key(_esc));
   // And when the world ends.
   for(theangleofme=0; theangleofme<50; theangleofme++)
        fade(0,0,0, 5);
        frame;
    end;

END



// Name: Create_explosion(x, y);
// Description:
// Just creates an explosion.

process create_explosion(x, y)
begin
  // This is a great trick for animation techniques. You simply loop
  // through the map numbers to produce the animation, just set
  // the graphic to that map number and simply loop it. The explosion
  // is just going to explode once, so we show the animation and then
  // exit the process.

  for(angledirectionz=8; angledirectionz<13; angledirectionz++)
    graph=angledirectionz;
    frame;
  end
end



// -- Wohoo! Line 807! See ya!