


//-----------------------------------------------------------------------------
//TITLE: PATH Demonstrator
//
//
//EXPLANATION:A simple program showing how to use structures for
// paths.The spacecraft fly about and draw a line
// behind them.
//
//NOTES: Press the escape key at anytime to exit.
// This is extremely basic and could be improved much more.
// If you dont want it to draw a line block out line 85.
// If you only want to see one ship in action bloack out 4
// lines between an including line 45 to line 49.I would
// advise blocking some of these lines so as to make the
// paths the ships take easier to follow.
//
//
//-----------------------------------------------------------------------------


PROGRAM PATHS;
CONST
GLOBAL

 STRUCT PATH[4]     //5 paths
  STRUCT POINTS[10]  //10 points on each path
   x;
   y;
  END
 END =
     90,700,840,700,840,90,90,90,85,700, DUP(0),
     90,740,840,740,840,90,90,90,90,740, DUP(0),
    551,2,449,410,19,220,222,30,39,40,59,60,90,70,100,30,20,5,80,70,
    1,1,50,50,50,50,50,14DUP(0); //format of these lines is x,y,x,y,x,y


 POINT_TABLE[4] = 5,5,2,10,3; //sets number of points in each path used by enemy process

LOCAL
 COUNTER=0;
 MAX=0;
 i=0;
PRIVATE

BEGIN
 set_mode(m320x200); // Sets video mode to 640x480

 LOAD_FPG("carz.fpg");
 put_screen(0,1);
   start_scroll(0,0,1,4,0,4);
    // Defines scroll region after which it will move
    scroll.region1=define_region(1,96,100,1,1);




 ENEMY(90,40,0);
 //ENEMY(90,40,1);
 //ENEMY(90,40,2);
 //  ENEMY(1,40,3);
 //ENEMY(1,40,4);

 LOOP
  IF(KEY(_ESC))
   EXIT("",0);
  END
  FRAME;
 END
END

//-----------------------------------------------------------------------------
// Process works out the next point that father must go to
// Entries: none
//-----------------------------------------------------------------------------


PROCESS ROUTE()
PRIVATE
BEGIN
 //changes fathers(enemy process that called it) angle
 father.ANGLE=fget_angle(father.x,father.y,path[father.i].POINTS[father.COUNTER].x,path[father.i].POINTS[father.COUNTER].y);

 //checks the dist to point
 IF(fget_dist(father.x,father.y,path[father.i].POINTS[father.COUNTER].x,path[father.i].POINTS[father.COUNTER].y)<5);
  //if reaches point go onto next one
  father.COUNTER++;
  IF(father.COUNTER>=father.MAX)
   //if at last point go back to first one
   father.COUNTER=0;
  END
 END

END

//-----------------------------------------------------------------------------
// Process
// Entries: x position,y position, path number
//-----------------------------------------------------------------------------


PROCESS ENEMY(x,y,i)
PRIVATE
BEGIN
  ctype=c_scroll;
      scroll.camera=id;

 MAX=POINT_TABLE[i] ; //number of points
 COUNTER=0;
 size=25;
 graph=41;
 angle=0;

LOOP
    if(key(_p))
        x+=1;
        y+=1;
     end
 ADVANCE(9);
 ROUTE();
 PUT_();
 FRAME;
END
END

//-----------------------------------------------------------------------------
// Process puts a white pixel where at fathers co-ordinates
// Entries:none
//-----------------------------------------------------------------------------

PROCESS PUT_()
BEGIN
put_pixel(father.x,father.y,235);
END
