
/*
      INTELLIGENT AIMING DEMO

      By Mark Frimston 20/1/02
        Website:    www.frimston.fsnet.co.uk
        E-mail:     mfrim@hotmail.com

      Feel free to use this code (or more importantly the
      aiming algorithm) in your own games/projects. For an
      enemy AI, I would recommend randomising the firing angle
      a little - you don't want to hit the player TOO often!

      Enjoy! :)
*/


PROGRAM ShooterAI;


GLOBAL
    Playerid;                     //Stores is of player

    Player_Run_Speed = 0;         //This is 200 when player is going forwards, -200 when going backwards
    Bullet_fly_speed = 500;

BEGIN
    load_fpg("shootrai.fpg");
    set_mode(m640x480);           //main initialisation
    set_fps(50,0);
    put_screen(0,4);

    Playerid=Player();
    Standard_turret();            //create processes
    Intelligent_turret();

    Write(0,320,50,4,"INTELLIGENT AIMING DEMO");
    Write(0,320,60,4,"by Mark Frimston");
    Write(0,320,70,4,"20/1/02");

    Write(0,10, 200,3,"This turret always aims towards player");
    Write(0,10, 210,3,"EASY TO DODGE!");

    Write(0,630,200,5,"This turret predicts where collision will occur");
    Write(0,630,210,5,"NOT EASY TO DODGE!");

    Write(0,320,440,4,"Use the cursor keys to move the player within range of the turrets");

    LOOP
        FRAME;
    END                           //main loop
END





PROCESS Player()                  //Player-controlled character
BEGIN
    Resolution=100;
    x=32000;
    y=24000;
    graph=3;
    angle=-90000;
    LOOP

        IF(key(_up))    Player_run_speed= 200; END;    //up to go forwards
        IF(key(_down))  Player_run_speed=-200; END;    //down to go backwards

        IF(NOT(key(_up) OR key(_down)))                //stop if neither is pressed
            Player_run_speed = 0;
        END

        IF(key(_left))  angle+=3000; END;              //left & right to turn
        IF(key(_right)) angle-=3000; END;

        advance(Player_run_speed);

        FRAME;
    END
END





PROCESS Standard_turret()        //Normal aiming turret

PRIVATE
    FireDelay;                   //used to count frames
                                 //between bullets
BEGIN
    Resolution=100;
    x=6400;
    y=24000;
    graph=1;
    angle=0;

    LOOP
        angle=get_angle(Playerid);                          //aim directly at player

        Firedelay++;                                        //increment firedelay
        IF(get_dist(Playerid) <= 20000 AND FireDelay>=5)    //if in range and enough delay frames have passed
            Bullet();                                       //fire bullet
            Firedelay=0;                                    //reset delay counter
        END

        FRAME;
    END
END





PROCESS Intelligent_turret()     //Turret that takes into account the time
                                 //it will take for the bullet to get there
PRIVATE
    FireDelay;

    PlayerAng;                   //Angle of Player
    AngToPlayer;                 //Angle towards player
    AngFromPlayer;               //Angle from player towards this turret

    Var_A;                       //Stores required info
    Var_B;
    Var_C;

BEGIN
    Resolution=100;
    x=57600;
    y=24000;
    graph=1;
    angle=180000;

    LOOP
        //Store required angles

        PlayerAng = Playerid.angle;
        AngToPlayer = get_angle(Playerid);
        AngFromPlayer = fget_angle(Playerid.x,Playerid.y,x,y);

        //***** THIS IS THE IMPORTANT BIT *****

        //I have split this code into four lines by storing
        //intermittant stages of the equation in variables,
        //but it would still work on one MASSIVE line if you want.

        Var_A = get_disty(AngFromPlayer-PlayerAng,100);
        Var_B = (Player_run_speed*Var_A)/Bullet_fly_Speed;
        Var_C = fget_angle(0,0,sqrt(pow(100,2)-pow(Var_B,2)),Var_B);
        Angle = Var_C+AngToPlayer;

        //*************************************

        Firedelay++;
        IF(get_dist(Playerid) <= 20000 AND FireDelay>=5)
            Bullet();
            Firedelay=0;
        END                      //Fire bullet
        FRAME;
    END
END




PROCESS Bullet();                //Bullet

BEGIN
    resolution=100;
    x=father.x;                  //get position and angle
    y=father.y;                  //of father (the turret)
    graph=2;
    angle=father.angle;

    LOOP
        advance(Bullet_fly_speed);

        IF(Collision(TYPE Player) <> 0)
            RETURN;                        //destroy if hit player
        END

        IF(Out_region(id,0))
            RETURN;                        //or if off screen
        END

        FRAME;
    END
END