PROGRAM Hangman;
// All code, gfx, sfx (c) Ian Price 2002 - iprice@supanet.com

GLOBAL

fnt="hangman.fnt";

fpg="hangman.fpg";

words[20000]; // Maximum number of letters for list
text[100];    // Maximum number of letters in clue
keyz[100];    // Number of keys
guess[100];   // Show guessed letters
shows[100];   // Hidden letters
letta[100];   // Chosen letter

press;  // Keypress delay

number; // Puzzle number

wrong;  // Number of wrong guesses

gotright[100];
getright;

alive;

BEGIN

SET_MODE(m640x480); // Medium/Hi-res mode

LOAD_FNT(fnt); // Load font

LOAD_FPG(fpg); // load graphics

title(); // Title screen

END


// Add new puzzles
PROCESS puzzle();
PRIVATE
n;   // n value
m;   // Key value
kee; // Value of key pressed
ok;  // Ensures only letters are used
max; // Number of letters in clue

BEGIN

// Load data
LOAD("hangman.dat",&words);
FROM n=0 TO 25;
text[n]=words[n];
END

LOOP

// Increase puzzle number
IF (KEY(_UP) AND press==0)
number++;
press=3;
 FROM n=0 TO 25;
 text[n]=words[n+(number*25)];
 END
max=0;
END

// Decrease puzzle number
IF (KEY(_DOWN) AND press==0 AND number>0)
number--;
press=3;
 FROM n=0 TO 25;
 text[n]=words[n+(number*25)];
 END
max=0;
END

DELETE_TEXT(ALL_TEXT);
WRITE(1,450,10,0,"PUZZLE");
WRITE_INT(1,600,10,0,&number);

WRITE(1,max*8+10,100,0,"_");

WRITE(1,10,400,0,"UP/DOWN - CHANGE PUZZLE NUMBER");

WRITE(1,10,450,0,"PRESS [RETURN] TO SAVE ALL DATA");

// Show puzzle name
FROM n=0 TO 24;
m=text[n];
 IF (m>0 AND m<99)
 WRITE(1,n*16+20,100,0,keyz[m]);
 END
END

// Test for keypress
IF (press==0)
FROM n=1 TO 88;
IF (KEY(n)<>0) m=n;END
END
END

// Get value of keypress
IF (m<>0)
kee=m-1;

ok=0;

// ENTER - Save text data
IF (m==28)
SAVE("hangman.dat",&words,20000);
END

// DELETE - Delete text
IF (m==14 AND max>0) text[max-1]=0;max--;END

// Only allow 25 letters in puzzle title
IF (max<25)

// Valid letter or SPACE pressed
IF (m>15 AND m<26) ok=1;END
IF (m>29 AND m<39) ok=1;END
IF (m>43 AND m<51) ok=1;END
IF (m==57) m=0;ok=1;press=3;END
END

press=3;

// Send letter value to text[] and words[] arrays
IF (ok==1)
text[max]=kee;
words[max+(number*25)]=kee;
max++;
END

m=0;
kee=0;

END

IF (press>0) press--;END

FRAME;
END
END


// Get keyboard codes
PROCESS get_codes();
PRIVATE
keys[]="ESC","1","2","3","4","5","6","7","8","9","0",
       "=","+","BACKSPACE","TAB","Q","W","E","R","T",
       "Y","U","I","O","P","[","]","ENTER","CTRL",
       "A","S","D","F","G","H","J","K","L",":","'",
       "'","LEFT SHIFT","#","Z","X","C","V","B","N",
       "M",",",".","/","RIGHT SHIFT","*","ALT",
       " ","CAPS LOCK","F1","F2","F3","F4","F5",
       "F6","F7","F8","F9","F10","NUM LOCK",
       "SCROLL LOCK","HOME","UP CURSOR","PAGE UP",
       "NUMPAD =","LEFT CURSOR","NUMPAD 5",
       "RIGHT CURSOR","NUMPAD +","END","DOWN CURSOR",
       "PAGE DOWN","INS","DELETE","?","?","\","F11",
       "F12"," ";

BEGIN
FROM x=0 TO 88;
keyz[x]=keys[x];
END
END


// Show dashes for letters
PROCESS show();
PRIVATE
n;
m;
kee;
ok;
letter;
correct; // Number of letters in puzzle
first;   // First pass
right;

BEGIN

number=RAND(0,150); // Number of puzzles (alter 150 if you add puzzles)

LOAD("hangman.dat",&words); // Load the data file

draw();

LOOP

DELETE_TEXT(ALL_TEXT);

FROM n=0 TO 24;

z=words[n+(number*25)];
y=guess[n];

// Show dashes in puzzle
IF (z>0 AND z<56)
WRITE(1,n*16+150,40,0,"=");
IF (first==0) correct++;END
END

// Show all guessed letters
IF (y>0 AND y<56)
WRITE(1,n*16+150,450,0,keyz[y]);
END

END

kee=0;

// Show correctly identified letters
FROM x=0 TO 24;
FROM y=0 TO 88;
kee=letta[y];

IF (words[x+(number*25)]==kee AND kee>0)
WRITE(1,x*16+150,25,0,keyz[kee]);
right++;
gotright[y]=1;
END

END
END

ok=0;
m=0;

getright=0;

FROM x=0 TO 88;
IF (gotright[x]==1) getright++;END
END

wrong=letter-getright;

// Test for keypress
IF (press==0)
FROM n=1 TO 88;
IF (KEY(n)<>0) m=n;END
END
END

// Get value of keypress
IF (m<>0)
kee=m-1;

// Valid letter pressed
IF (m>15 AND m<26) ok=1;END
IF (m>29 AND m<39) ok=1;END
IF (m>43 AND m<51) ok=1;END
END

IF (ok==1 AND letta[m]==0)
letter++;
letta[m]=kee;
guess[letter]=kee;
press=3;

END

first=1;

// Start a new puzzle (Reset all variables)
IF (KEY(_ENTER) AND press==0)
 FROM n=0 TO 100;
 letta[n]=0;
 guess[n]=0;
 text[n]=0;
 gotright[n]=0;
 END

number=RAND(0,150);
press=4;
x=0;
y=0;
z=0;
n=0;
m=0;
kee=0;
letter=0;
right=0;
correct=0;
first=0;
wrong=0;
alive=0;
getright=0;
draw();
pict();
END

// Slowdown keypresses
IF (press>0) press--;END

// Complete puzzle
IF (right>0 AND correct==right)
IF (alive==0) darken();alive=2;END
WRITE(1,140,200,0,"WELL DONE. PUZZLE COMPLETE!");
WRITE(1,137,250,0,"PRESS [RETURN] TO PLAY AGAIN");
END

// Fail to complete puzzle
IF (alive==1)
WRITE(1,100,200,0,"GAME OVER. YOUR VICTIM HAS HANGED!");
WRITE(1,137,250,0,"PRESS [RETURN] TO PLAY AGAIN");

 // Reveal puzzle
 FROM x=0 TO 24;
 m=words[x+(number*25)];
 IF (m>0 AND m<99) WRITE(1,x*16+150,25,0,keyz[m]);END
 END

END

right=0;

FRAME;

END
END


// Draw body parts etc.
PROCESS pict();
BEGIN
LOOP

IF (alive>0) RETURN;END

IF (wrong==1) // Jib base
 FROM x=172 TO 467;
 FROM y=384 TO 403;
 PUT_PIXEL(x,y,1);
 END
 END
END

IF (wrong==2) // Jib upright
 FROM x=172 TO 189;
 FROM y=78 TO 384;
 PUT_PIXEL(x,y,1);
 END
 END
END

IF (wrong==3) // Jib top
 FROM x=172 TO 467;
 FROM y=78 TO 95;
 PUT_PIXEL(x,y,1);
 END
 END
END

IF (wrong==4) // Bottom strut
XPUT(0,4,230,342,0,200,2,0);
END

IF (wrong==5) // Top strut
XPUT(0,4,230,136,0,200,0,0);
END

IF (wrong==6) // Rope
XPUT(0,5,408,120,0,200,0,0);
END

IF (wrong==7) // Head
XPUT(0,3,408,182,0,200,0,0);
END

IF (wrong==8) // Body
XPUT(0,6,408,266,0,200,0,0);
END

IF (wrong==9) // Right arm
XPUT(0,7,434,248,0,200,0,0);
END

IF (wrong==10) // Left arm
XPUT(0,7,382,248,0,200,1,0);
END

IF (wrong==11) // Right leg
XPUT(0,8,434,326,0,200,0,0);
END

IF (wrong==12) // Left leg
XPUT(0,8,382,326,0,200,1,0);
alive=1;
END

// Lose game
IF (alive==1)
darken();
END

FRAME;

END
END


// Draw background
PROCESS draw();
BEGIN

FROM x=150 TO 489;
FROM y=56 TO 425;
PUT_PIXEL(x,y,16);
END
END

FROM x=166 TO 474;
FROM y=60 TO 63;
PUT_PIXEL(x,y,0);
PUT_PIXEL(x,y+358,0);
END
END

FROM x=154 TO 157;
FROM y=66 TO 420;
PUT_PIXEL(x,y,0);
PUT_PIXEL(x+328,y,0);
END
END

XPUT(0,2,158,64,0,200,0,0);
XPUT(0,2,480,64,0,200,1,0);
XPUT(0,2,158,416,0,200,2,0);
XPUT(0,2,480,416,0,200,3,0);
END


// Darken background
PROCESS darken();
PRIVATE
get;
BEGIN
FROM x=150 TO 500;
FROM y=50 TO 450;
get=GET_PIXEL(x,y);
IF (get==16) PUT_PIXEL(x,y,23);END
IF (get==1) PUT_PIXEL(x,y,109);END
END
END
END


// Title screen
PROCESS title();
BEGIN
LOOP
DELETE_TEXT(ALL_TEXT);
WRITE(1,250,100,0,"HANGMAN");
WRITE(1,220,300,0,"BY IAN PRICE");
WRITE(1,170,350,0,"IPRICE@SUPANET.COM");

WRITE(1,170,450,0,"PRESS SPACE TO PLAY");

IF (KEY(_SPACE) AND press==0)
press=10;

get_codes();   // Get keyboard scan codes
show();        // Show dashes
pict();        // Draw picture

//puzzle(); // Add new puzzles (Comment out show() and pict() above)
            // Don't forget to alter RAND(0,150) to show new puzzles
            // I've allocated space for about 800 puzzles.

RETURN;
END

FRAME;
END
END

