//-------------------------------------------------------------------------
/*
    CW_TUTOR.PRG

    Charles Wardlaw's First DIV Tutorial program code.

    Please feel free to share this code with everyone you know.  If you
    find it useful, drop me a line at cloud@gadget.f2s.com.

    More juicy goodness may be available from my webpage at
    http://www.gadget.f2s.com/
*/
//-------------------------------------------------------------------------

Program CW_Tutor;

Const

    // should be plenty of space for sounds...
    MAX_SOUNDS = 255;

    // shot originator tags
    SHOT_PLAYER = 1;
    SHOT_ENEMY  = 2;

    // how fast buddies launch
    BUDDY_LAUNCH_RATE = 500;

    // total number of different weapons
    MAX_SHOT_TYPES = 3;

    // powerup types
    POW_NONE        = 0;
    POW_DOUBLE      = 1;        // double shots
    POW_TRIPLE      = 2;        // triple shots
    POW_WEAPONPLUS  = 3;        // weapon type upgrade
    POW_NUCLEAR     = 4;        // extra nova bombs

    // max number of powerups
    POW_TYPEMAX     = 4;

    // directions
    DIR_LEFT        = 1;
    DIR_RIGHT       = 2;
    DIR_UP          = 3;
    DIR_DOWN        = 4;

    // ownership
    OWNER_PLAYER    = 1;        // it's a player bullet
    OWNER_BADDY     = 2;        // it a bullet from an enemy

    // sparkle stuff
    star_traveldist = 3;

Global

    // the tag number of the graphics FPG
    fpg_id;
    // the tag number of my font
    font_id;
    // the tag number of my explosion FPG
    explode_id;

    // sound id's will go here
    sounds[MAX_SOUNDS];
    // where we should add the next sound id
    sound_counter;

// player information
    // player's id number
    player_id;
    // buddies add extra shots, etc
    buddy1_id; buddy2_id;
    // we can only fire if this reaches 0
    shot_counter = 0;
    // number of nova bombs left
    num_novas = 0;


// powerup information
    // helps decide what bullets to give the player
    num_powers_collected;
    // boolean for powerups
    bool_invincible = false;
    bool_doubleshot = false;
    bool_tripleshot = false;
    // counter for temporary powerups
    powerup_counter = 0;

// various text id holders

    text_shot_var;
    text_shot_id;
    text_nova1_id;
    text_nova2_id;

    // sparkle stuff
    starsfpg_id;
    countdown = 0;


Local

    // type of bullet the process fires
    shot_type;
    // type of powerup held
    powerup_type;
    // frame counter
    frame_ctr;

    // For shots and other things that need to move on an angle, but not
    // have their sprite rotated.  This variable is a trick: I set the
    // actual angle, move the process, and then set the angle to 0 so that
    // the sprite isn't drawn rotated.
    temp_angle;

    // owner of a shot -- like a parent, but I use this variable because
    // I'm using middle-man processes to launch things
    owner;

    // how much life a process has left
    hp;

Private

    i,j,k;

Begin

    set_mode(m640x480);
    set_fps(30, 4);

    // with so many little parts of the screen to update (the starfield)
    // using a partial dump (dirty rectangles) slows the game down to
    // a crawl, even on my pentium III-666 =)
    dump_type = complete_dump;

    fpg_id  = load_fpg("cwtutor.fpg");
    font_id = load_fnt("geom_1.fnt");
    starsfpg_id = load_fpg("stars1.fpg");
    explode_id = load_fpg("explode2.fpg");

    // this region is defined larger than the screen so a process can
    // be launched outside the screen and I can still use out_region
    // to kill it off

    define_region(1, -40, -40, 720, 560);

    // launch a player
    player_id = player(320, 440, 1);

    // start the scrolling starscape
    start_scroll(0, fpg_id, 2, 1, 0, 15);

// main loop begins here

    while (!key(_ESC))

        // launch some enemies

        // launch a buddy
        if (rand(0,BUDDY_LAUNCH_RATE) == 4 or key(_B))

            i = rand(1,POW_TYPEMAX);

            switch(i)

                case 1 :
                    if (bool_doubleshot == false and bool_tripleshot == false)
                        Buddy1(640, 240, 180000, POW_DOUBLE);
                    end
                end

                case 2 :
                    if (bool_doubleshot == true)
                        Buddy1(640, 240, 180000, POW_TRIPLE);
                    end
                end

                // launch a buddy with a weapon upgrade
                case 3 :
                    if (player_id.shot_type < MAX_SHOT_TYPES)
                        Buddy1(640, 240, 180000, POW_WEAPONPLUS);
                    end
                end

                // nova bombs
                case 4 :
                    Buddy1(640, 240, 180000, POW_NUCLEAR);
                end

                default : end;
            end
        end

        // launch an enemy
        if (rand (0, 25) == 0)
            Enemy_One(rand(40, 600), -20);
        end

        // move the starscape scrolling background
        // background (x1,y1) scrolls at half speed
        scroll[0].y0 -= 8;
        scroll[0].y1 -= 4;

        // write some information to the screen
        text_shot_id = write_int(font_id, 0, 0, 0, OFFSET text_shot_var);
        text_nova1_id = write(font_id, 480, 0, 0, "NOVA'S LEFT:");
        text_nova2_id = write_int(font_id, 610, 0, 0, OFFSET num_novas);
        frame;

        // delete the text so we don't have unlimited text showing
        delete_text(text_shot_id);
        delete_text(text_nova1_id);
        delete_text(text_nova2_id);

    end // main loop

// cleanup

    delete_text(ALL_TEXT);
    let_me_alone();

End // main process

//-------------------------------------------------------------------------
/*
    Player's Process
*/
//-------------------------------------------------------------------------

Process player(x,y, shot_type)

Private

    // we animate when this reaches 0
    anim_counter = 0;

Begin

    graph = 50;

    shot_type = 1;

    for (;;)

        // moving around based on input

        if (key(_LEFT) or joy.left)
            x -= 7;
        end

        if (key(_RIGHT) or joy.right)
            x += 7;
        end

        if (key(_UP) or joy.up)
            y -= 4;
        end

        if (key(_DOWN) or joy.down)
            y += 4;
        end

/*
    debug code
*/

        if (key(_1)) shot_type = 1; end
        if (key(_2)) shot_type = 2; end
        if (key(_3)) shot_type = 3; end


        // shot stuff
        if (shot_counter > 0)
            shot_counter--;
        else
            // do some shooting based on current weapon
            // basically passes player's info to the shot launcher

            if (key(_CONTROL) or joy.button1)

                ShotLaunch(x,y-10,angle,shot_type,OWNER_PLAYER);

            end

            // novas are a special case
            if ( (key(_SPACE) or joy.button2) and num_novas > 0)

                // kill them all!
                num_novas--;
                NOVABLAST();

                // higher recovery time...
                shot_counter = 10;
            end
        end

        // update the text variable
        text_shot_var = shot_type;

        // animating
        if (anim_counter > 0)
            anim_counter--;
        else
            // animate the ship
            graph++;
            if (graph == 52) graph = 50; end

            // reset the counter so they keep animating
            anim_counter = 4;
        end

        // fix bad coordinates
        if (x < 40) x = 40; end
        if (x > 600) x = 600; end
        if (y < 400) y = 400; end         // stay at the bottom
        if (y > 449) y = 449; end       // of the screen (400 < y < 480)


        frame;
    end

End // player process

//-------------------------------------------------------------------------
/*
    ShotLaunch Process

    Launches different shots depending on parameter given.  Also, if the
    player has the double-shot powerup it'll fire two of the same type.
    It's also responsible for deploying the 5-way spreadshot.
*/
//-------------------------------------------------------------------------

Process ShotLaunch(x,y,angle,shot_type,owner)

Begin


    // the angle must be modified -- if it's not the shot will go
    // off at an extra 90 degrees...

    angle += 90000;

    switch(shot_type)

        case 1 :
            if (bool_tripleshot)
                shot_one(x-10,y,angle,owner);
                shot_one(x,y,angle,owner);
                shot_one(x+10,y,angle,owner);
            else
                if (bool_doubleshot)
                    shot_one(x-5,y,angle,owner);
                    shot_one(x+5,y,angle,owner);
                else
                    shot_one(x,y,angle,owner);
                end
            end
        end

        case 2 :
            if (bool_tripleshot)
                shot_two(x-10,y,angle,owner);
                shot_two(x,y,angle,owner);
                shot_two(x+10,y,angle,owner);
            else
                if (bool_doubleshot)
                    shot_two(x-5,y,angle,owner);
                    shot_two(x+5,y,angle,owner);
                else
                    shot_two(x,y,angle,owner);
                end
            end
        end

        case 3 :
            shot_three(x,y,angle-45000,owner);
            shot_three(x,y,angle-22500,owner);
            shot_three(x,y,angle,owner);
            shot_three(x,y,angle+22500,owner);
            shot_three(x,y,angle+45000,owner);
        end

        default : end;
    end

End // shotlaunch

//-------------------------------------------------------------------------
/*
    Shot_One Process

    Regular shot, a simple pellet.
*/
//-------------------------------------------------------------------------

Process shot_one(x,y,temp_angle,owner)

Begin

    graph = 252;

    // reset the shot counter so there isn't a stream
    shot_counter = 10;

    while (!out_region(reserved.process_id, 0))

        angle = temp_angle;
        advance(6);
        angle = 0;
        frame;

    end;

End // shot_one

//-------------------------------------------------------------------------
/*
    Shot_Two Process

    Animated Missle Shot, does more damage.  Uses the same animation
    technique seen above in the player's process.  Also launches faster
*/
//-------------------------------------------------------------------------

Process shot_two(x,y,temp_angle, owner)

Private

    anim_counter = 0;

Begin

    graph = 250;

    // reset the shot counter so there isn't a stream
    shot_counter = 7;

    while (!out_region(reserved.process_id, 0))

        // movement
        angle = temp_angle;
        advance(6);
        angle = 0;

        // animation
        if (anim_counter > 0)
            anim_counter--;
        else
            // animate the ship
            graph++;
            if (graph == 252) graph = 250; end

            // reset the counter so they keep animating
            anim_counter = 4;
        end

        frame;

    end

End // shot_two

//-------------------------------------------------------------------------
/*
    Shot_Three Process

    Spreadfire shot -- 5 bullets are fired at once, from inside ShotLaunch.

    This bullet it weaker to account for its spreadfire.
*/
//-------------------------------------------------------------------------

Process shot_three(x,y,temp_angle, owner)

Begin

    graph = 253;

    // reset the shot counter so there isn't a stream
    shot_counter = 10;

    while (!out_region(reserved.process_id, 0))

        angle = temp_angle;
        advance(6);
        angle = 0;
        frame;

    end

End

//-------------------------------------------------------------------------
/*
    Buddy1 Process

    Buddies are little ships that, when shot, drop powerup icons.
*/
//-------------------------------------------------------------------------

Process Buddy1(x,y,temp_angle,powerup_type)

Private

    anim_counter;

    i;

Begin

    graph = 100;

    while (!out_region(reserved.process_id, 1))

        // shot collisions
        i = collision(type shot_one);
        if (i != 0)

            // we're hit captain ... drop the powerup and die
            powerup(x,y,powerup_type);

            // move out of the region so we die
            x = -1000;
            y = -1000;

            // kill the bullet, too
            signal(i, s_kill);
        end

        i = collision(type shot_two);
        if (i != 0)
            // we're hit captain ... drop the powerup and die
            powerup(x,y,powerup_type);

            // move out of the region so we die
            x = -1000;
            y = -1000;

            // kill the bullet, too
            signal(i, s_kill);
        end

        i = collision(type shot_three);
        if (i != 0)
            // we're hit captain ... drop the powerup and die
            powerup(x,y,powerup_type);

            // move out of the region so we die
            x = -1000;
            y = -1000;

            // kill the bullet, too
            signal(i, s_kill);
        end

        // animation
        if (anim_counter > 0)
            anim_counter--;
        else
            // animate the ship
            graph++;
            if (graph == 102) graph = 100; end

            // reset the counter so they keep animating
            anim_counter = 6;
        end

        angle = temp_angle;
        advance(2);
        angle -= 90000;
        frame;

    end

End

//-------------------------------------------------------------------------
/*
    PowerUp Process

    Powerups in this example do one of three things:

        1) Give the player a better weapon
        2) Give the player double or triple shots
        3) Give the player extra nova bombs (kill all enemies)

    Powerups must be touched by the player to be collected.
*/
//-------------------------------------------------------------------------

Process powerup(x,y,powerup_type)

Private

    rot_dir = DIR_LEFT;
    sparkle_time;

Begin

    graph = 199 + powerup_type;

    // novas are too big and I don't feel like redrawing them ^.^
    if (powerup_type == POW_NUCLEAR)
        size = 50;
    end

    while (!out_region(reserved.process_id, 0))

        // collision stuff with player
        if (collision(type player))

            // give the player the powerup

            switch(powerup_type)

                case POW_DOUBLE :

                    bool_doubleshot = true;
                    bool_tripleshot = false;

                    // move out of the region so it dies
                    x = y = -1000;
                end;

                case POW_TRIPLE :

                    bool_doubleshot = false;
                    bool_tripleshot = true;
                end

                case POW_WEAPONPLUS :

                    if (player_id.shot_type < MAX_SHOT_TYPES)
                        player_id.shot_type++;
                    end
                end

                case POW_NUCLEAR :
                    num_novas++;
                end

                default : end
            end

            // move out of the region so it dies
            x = y = -1000;
        end

        // animation
        if (rot_dir == DIR_LEFT)
            if (angle =< 45000)
                angle += 5000;
            else
                rot_dir = DIR_RIGHT;
            end
        end

        if (rot_dir == DIR_RIGHT)
            if (angle >= -45000)
                angle -= 5000;
            else
                rot_dir = DIR_LEFT;
            end
        end

        // time to drop a sparkle?
        if (sparkle_time == 0)
            sparkle(x,y);
            sparkle_time += 4;
        else
            sparkle_time--;
        end

        // move it closer to the player, magnetic-like. ^.^
        if (x < player_id.x)
            x += 2;
        end

        if (x > player_id.x)
            x -= 2;
        end

        if (y < player_id.y)
            y += 2;
        end

        if (y > player_id.y)
            y -= 2;
        end

        frame;
    end
End // powerup

//-------------------------------------------------------------------------
/*
    NOVABLAST Process

    Kills all enemies on the screen.  Yeah, it should probably be flashier,
    but I'm too tired to think up a cool effect right now. ^.^
*/
//-------------------------------------------------------------------------

Process NOVABLAST()

Private

    i,j;

Begin

    // slow down for effect ^.^
    set_fps(6, 4);

    repeat

        i = get_id(type enemy_one);

        if (i)
            // big boom... big bada-boom
            Boom(i.x, i.y, 200);
            // kill off enemy
            signal(i, s_kill);
        end

        j = get_id(type Buddy1);

        if (j)
            // smaller bada-boom
            Boom(j.x, j.y, 200);
            // kill off buddy
            signal(j, s_kill);
            // launch a goody
            powerup(j.x, j.y, j.powerup_type);
        end

    until ( (i + j)  == 0 );

    // back to normal speed
    set_fps(30, 4);

End // NOVABLAST

//-------------------------------------------------------------------------
/*
    Sparkle Process

    I wanted an effect similar to the sparkles that the faeries drop in
    the Shining Force games.  Here's my effort; let me know what you think.
*/
//-------------------------------------------------------------------------

Process sparkle(x,y);

Private

    done = false;
    xspeed;
    yspeed;
    rotspeed;

Begin

    file = starsfpg_id;
    graph = 5;

    size = 20;

    xspeed = rand(-5, 5);
    yspeed = rand (-5, 5);
    rotspeed = rand(10, 30);
    rotspeed *= 1000;

    if (rand(1,2) == 1)
        rotspeed = -rotspeed;
    end


    while (!done and !out_region(reserved.process_id, 0))

        x += xspeed;
        y += yspeed;
        angle += rotspeed;
        size--;

        if (size <= 0)

            done = true;

        end

        frame;

    end
End

//-------------------------------------------------------------------------
/*
    Enemy_One Process

    Simple enemy, simple animation.

    This process gets interesting when it collides with a bullet -- here
    we see that some bullets are stronger than others.
*/
//-------------------------------------------------------------------------

Process Enemy_One(x,y)

Private

    i;

Begin

    graph = 150;
    angle = 180000;
    hp = 5;

    while (!out_region(reserved.process_id, 1))

        // collisions
        i = collision(type shot_one);
        if (i)
            hp -= 3;
            boom(i.x, i.y, 20);
            // kill the bullet
            signal(i, s_kill);
        end

        i = collision(type shot_two);
        if (i)
            hp -= 5;
            boom(i.x, i.y, 20);
            signal(i, s_kill);
        end

        i = collision(type shot_three);
        if (i)
            hp -= 1;
            boom(i.x, i.y, 20);
            signal(i, s_kill);
        end

        // move
        if (hp < 1)
            // we're dead -- act accordingly
            boom(x,y,rand(45,55));
            x = y = -1000;
        else
            y += 4;
        end

        // animate
        graph ++;
        if (graph == 153) graph = 150; end

        frame;
    end
End // enemy_one

//-------------------------------------------------------------------------
/*
    Boom Process

    Simple explosion animation
*/
//-------------------------------------------------------------------------

Process Boom(x,y,size);

Begin

    file = explode_id;

    for ( graph = 1; graph < 17; graph++)

        frame;

    end
End
