//-------------------------------------------------------------------------
/*
    TUTOR1.PRG

    Demonstrates using the parallax scroll background.
*/
//-------------------------------------------------------------------------

Program TUTOR1;

Global

    // the id tag of our FPG file
    fpg_id;

Begin

    // make sure the entire screen gets copied each frame
    dump_type = complete_dump;

    // use more frames per second, for smoother animation
    set_fps(30, 4);

    // load our graphics
    fpg_id = load_fpg("cwtutor.fpg");

    // start a scrolling starscape
    start_scroll( 0,        // use region 0 - the entire screen
                  fpg_id,   // use our loaded FPG
                  2,        // use image #2 in the FPG for the foreground
                  1,        // use image #1 for the background
                  0,        // which window you want to use, from 0 - 9
                  15 );     // do a repeating scroll in all directions

    // main loop begins here
    while (!key(_ESC))

        // move the starscape depending on input
        if (key(_UP))
            scroll[0].y0 -= 8;  // foreground (on top)
            scroll[0].y1 -= 4;  // background (below -- half the speed!)
        end

        if (key(_DOWN))
            scroll[0].y0 += 8;
            scroll[0].y1 += 4;
        end

        if (key(_LEFT))
            scroll[0].x0 -= 8;
            scroll[0].x1 -= 4;
        end

        if (key(_RIGHT))
            scroll[0].x0 += 8;
            scroll[0].x1 += 4;
        end

        // make sure we draw
        frame;
    end

    // done the program!
    let_me_alone();
    delete_text(all_text);

End // main program process
