//-------------------------------------------------------------------------
/*
    TUTOR2.PRG

    Demonstrates different kinds of shots for the player's use.
*/
//-------------------------------------------------------------------------

Program TUTOR2;

Global

    // the id tag of our FPG file
    fpg_id;

    // the id tag of our player's process
    player_id;

    // we can shoot when this reaches 0
    shot_counter = 0;

Local

    shot_type;

Begin

    // higher resolution because I say so =)
    set_mode(m640x480);

    // use more frames per second, for smoother animation
    set_fps(30, 4);

    // load our graphics
    fpg_id = load_fpg("cwtutor.fpg");

    // launch a player, save its id
    player_id = player(320, 440);


    // print a message
    write(0, 320, 240, 4, "Hit space to launch a buddy");
    // main program loop
    while (!key(_ESC))

        if (key(_SPACE))

            // launch a buddy
            // carries a random item
            buddy(638, 240, rand(1,3));

        end

        frame;

    end

    // time to clean up
    let_me_alone();
    delete_text(all_text);

End // main program process

//-------------------------------------------------------------------------
/*
    Player's Process
*/
//-------------------------------------------------------------------------

Process player(x,y)

Private

    // we animate when this reaches 0
    anim_counter = 0;

Begin

    // images for our ship animation start at 50 in my FPG
    graph = 50;

    // default shot is type 1 - regular "bullets"
    shot_type = 1;

    // loop forever
    for (;;)

        // moving around based on input

        if (key(_LEFT) or joy.left)
            x -= 7;
        end

        if (key(_RIGHT) or joy.right)
            x += 7;
        end

        if (key(_UP) or joy.up)
            y -= 4;
        end

        if (key(_DOWN) or joy.down)
            y += 4;
        end

        // since this is a tutorial we can cheat to see the
        // different weapon types
        if (key(_1)) shot_type = 1; end
        if (key(_2)) shot_type = 2; end
        if (key(_3)) shot_type = 3; end

        // shot stuff
        if (shot_counter > 0)
            shot_counter--;
        else
            // do some shooting based on current weapon
            // basically passes player's info to the shot launcher

            if (key(_CONTROL) or joy.button1)

                ShotLaunch(x,y-10,90000,shot_type);

            end
        end

        // animating
        if (anim_counter > 0)
            anim_counter--;
        else
            // animate the ship
            graph++;
            if (graph == 52) graph = 50; end

            // reset the counter so they keep animating
            anim_counter = 4;
        end

        // fix bad coordinates
        if (x < 40) x = 40; end
        if (x > 600) x = 600; end
        if (y < 400) y = 400; end       // stay at the bottom
        if (y > 449) y = 449; end       // of the screen (400 < y < 480)

        frame;
    end

End // player process

//-------------------------------------------------------------------------
/*
    ShotLaunch Process

    Launches different shots depending on parameter given.  Also, if the
    player has the double-shot powerup it'll fire two of the same type.
    It's also responsible for deploying the 5-way spreadshot.
*/
//-------------------------------------------------------------------------

Process ShotLaunch(x,y,angle,shot_type)

Begin

    switch(shot_type)

        case 1 :
            shot_one(x,y);
        end

        case 2 :
            shot_two(x,y);
        end

        case 3 :
            shot_three(x,y,angle-45000);
            shot_three(x,y,angle-22500);
            shot_three(x,y,angle);
            shot_three(x,y,angle+22500);
            shot_three(x,y,angle+45000);
        end

        default : end;
    end

End // shotlaunch

//-------------------------------------------------------------------------
/*
    Shot_One Process

    Regular shot, a simple pellet.
*/
//-------------------------------------------------------------------------

Process shot_one(x,y)

Begin

    graph = 252;

    // reset the shot counter so there isn't a stream
    shot_counter = 10;

    while (!out_region(reserved.process_id, 0))

        y -= 6;
        frame;

    end;

End // shot_one

//-------------------------------------------------------------------------
/*
    Shot_Two Process

    Animated Missle Shot, does more damage.  Uses the same animation
    technique seen above in the player's process.  Also launches faster
*/
//-------------------------------------------------------------------------

Process shot_two(x,y)

Private

    anim_counter = 0;

Begin

    graph = 250;

    // reset the shot counter so there isn't a stream
    shot_counter = 7;

    while (!out_region(reserved.process_id, 0))

        // movement
        y -= 6;

        // animation
        if (anim_counter > 0)
            anim_counter--;
        else
            // animate the ship
            graph++;
            if (graph == 252) graph = 250; end

            // reset the counter so they keep animating
            anim_counter = 4;
        end

        frame;

    end

End // shot_two

//-------------------------------------------------------------------------
/*
    Shot_Three Process

    Spreadfire shot -- 5 bullets are fired at once, from inside ShotLaunch.

    This bullet it weaker to account for its spreadfire.
*/
//-------------------------------------------------------------------------

Process shot_three(x,y,angle)

Begin

    graph = 254;

    // reset the shot counter so there isn't a stream
    shot_counter = 10;

    while (!out_region(reserved.process_id, 0))

        advance(6);
        frame;

    end

End

//-------------------------------------------------------------------------
/*
    Buddy1 Process

    Buddies are little ships that, when shot, drop powerup icons.
*/
//-------------------------------------------------------------------------

Process Buddy(x,y,powerup_type)

Private

    // what it's carrying
    powerup_type;
    anim_counter;
    i;

Begin

    graph = 102;

    // stay alive while on-screen
    while (!out_region(reserved.process_id, 0))

        // shot collisions
        i = collision(type shot_one);
        if (i != 0)

            // we're hit captain ... drop the powerup and die
            powerup(x,y,powerup_type);

            // move out of the region so we die
            x = -1000;
            y = -1000;

            // kill the bullet, too
            signal(i, s_kill);
        end

        i = collision(type shot_two);
        if (i != 0)
            // we're hit captain ... drop the powerup and die
            powerup(x,y,powerup_type);

            // move out of the region so we die
            x = -1000;
            y = -1000;

            // kill the bullet, too
            signal(i, s_kill);
        end

        i = collision(type shot_three);
        if (i != 0)
            // we're hit captain ... drop the powerup and die
            powerup(x,y,powerup_type);

            // move out of the region so we die
            x = -1000;
            y = -1000;

            // kill the bullet, too
            signal(i, s_kill);
        end

        // animation
        if (anim_counter > 0)
            anim_counter--;
        else
            // animate the ship
            graph++;
            if (graph == 104) graph = 102; end

            // reset the counter so they keep animating
            anim_counter = 6;
        end

        // move left to right
        angle = 180000;
        advance(2);
        frame;

    end

End

//-------------------------------------------------------------------------
/*
    PowerUp Process

    Powerups in this example do one of three things:

        1) Give the player a better weapon
        2) Give the player double or triple shots
        3) Give the player extra nova bombs (kill all enemies)

    Powerups must be touched by the player to be collected.
*/
//-------------------------------------------------------------------------

Process powerup(x,y,powerup_type)

Private

    rot_dir = 0;

Begin

    graph = 199 + powerup_type;

    while (!out_region(reserved.process_id, 0))

        // collision stuff with player
        if (collision(type player))

            // give the player the powerup
            // here we'll just kill the powerup

            // move out-region so it dies.
            x = y = -1000;
        end

        // animation
        if (rot_dir == 0)
            if (angle =< 45000)
                angle += 5000;
            else
                rot_dir = 1;
            end
        end

        if (rot_dir == 1)
            if (angle >= -45000)
                angle -= 5000;
            else
                rot_dir = 0;
            end
        end

        // move it closer to the player, magnetic-like. ^.^
        if (x < player_id.x)
            x += 2;
        end

        if (x > player_id.x)
            x -= 2;
        end

        if (y < player_id.y)
            y += 2;
        end

        if (y > player_id.y)
            y -= 2;
        end

        frame;
    end

End // powerup

